package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.globalaccelerator.model.primitives.{
  IdempotencyToken,
  GenericString
}
import scala.jdk.CollectionConverters._
final case class CreateCustomRoutingListenerRequest(
    acceleratorArn: GenericString,
    portRanges: Iterable[zio.aws.globalaccelerator.model.PortRange],
    idempotencyToken: IdempotencyToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.CreateCustomRoutingListenerRequest = {
    import CreateCustomRoutingListenerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.CreateCustomRoutingListenerRequest
      .builder()
      .acceleratorArn(GenericString.unwrap(acceleratorArn): java.lang.String)
      .portRanges(portRanges.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .idempotencyToken(
        IdempotencyToken.unwrap(idempotencyToken): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.CreateCustomRoutingListenerRequest.ReadOnly =
    zio.aws.globalaccelerator.model.CreateCustomRoutingListenerRequest
      .wrap(buildAwsValue())
}
object CreateCustomRoutingListenerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.CreateCustomRoutingListenerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.CreateCustomRoutingListenerRequest =
      zio.aws.globalaccelerator.model.CreateCustomRoutingListenerRequest(
        acceleratorArn,
        portRanges.map { item =>
          item.asEditable
        },
        idempotencyToken
      )
    def acceleratorArn: GenericString
    def portRanges: List[zio.aws.globalaccelerator.model.PortRange.ReadOnly]
    def idempotencyToken: IdempotencyToken
    def getAcceleratorArn: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(acceleratorArn)
    def getPortRanges: ZIO[Any, Nothing, List[
      zio.aws.globalaccelerator.model.PortRange.ReadOnly
    ]] = ZIO.succeed(portRanges)
    def getIdempotencyToken: ZIO[Any, Nothing, IdempotencyToken] =
      ZIO.succeed(idempotencyToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.CreateCustomRoutingListenerRequest
  ) extends zio.aws.globalaccelerator.model.CreateCustomRoutingListenerRequest.ReadOnly {
    override val acceleratorArn: GenericString =
      zio.aws.globalaccelerator.model.primitives
        .GenericString(impl.acceleratorArn())
    override val portRanges
        : List[zio.aws.globalaccelerator.model.PortRange.ReadOnly] = impl
      .portRanges()
      .asScala
      .map { item =>
        zio.aws.globalaccelerator.model.PortRange.wrap(item)
      }
      .toList
    override val idempotencyToken: IdempotencyToken =
      zio.aws.globalaccelerator.model.primitives
        .IdempotencyToken(impl.idempotencyToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.CreateCustomRoutingListenerRequest
  ): zio.aws.globalaccelerator.model.CreateCustomRoutingListenerRequest.ReadOnly =
    new Wrapper(impl)
}
