package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.globalaccelerator.model.primitives.{Timestamp, GenericString}
import scala.jdk.CollectionConverters._
final case class ByoipCidrEvent(
    message: Option[GenericString] = None,
    timestamp: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrEvent = {
    import ByoipCidrEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrEvent
      .builder()
      .optionallyWith(
        message.map(value => GenericString.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(timestamp.map(value => Timestamp.unwrap(value): Instant))(
        _.timestamp
      )
      .build()
  }
  def asReadOnly: zio.aws.globalaccelerator.model.ByoipCidrEvent.ReadOnly =
    zio.aws.globalaccelerator.model.ByoipCidrEvent.wrap(buildAwsValue())
}
object ByoipCidrEvent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrEvent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.ByoipCidrEvent =
      zio.aws.globalaccelerator.model.ByoipCidrEvent(
        message.map(value => value),
        timestamp.map(value => value)
      )
    def message: Option[GenericString]
    def timestamp: Option[Timestamp]
    def getMessage: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("message", message)
    def getTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("timestamp", timestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrEvent
  ) extends zio.aws.globalaccelerator.model.ByoipCidrEvent.ReadOnly {
    override val message: Option[GenericString] = scala
      .Option(impl.message())
      .map(value =>
        zio.aws.globalaccelerator.model.primitives.GenericString(value)
      )
    override val timestamp: Option[Timestamp] = scala
      .Option(impl.timestamp())
      .map(value => zio.aws.globalaccelerator.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrEvent
  ): zio.aws.globalaccelerator.model.ByoipCidrEvent.ReadOnly = new Wrapper(impl)
}
