package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateCustomRoutingAcceleratorResponse(
    accelerator: Option[
      zio.aws.globalaccelerator.model.CustomRoutingAccelerator
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorResponse = {
    import UpdateCustomRoutingAcceleratorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorResponse
      .builder()
      .optionallyWith(accelerator.map(value => value.buildAwsValue()))(
        _.accelerator
      )
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.UpdateCustomRoutingAcceleratorResponse.ReadOnly =
    zio.aws.globalaccelerator.model.UpdateCustomRoutingAcceleratorResponse
      .wrap(buildAwsValue())
}
object UpdateCustomRoutingAcceleratorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.UpdateCustomRoutingAcceleratorResponse =
      zio.aws.globalaccelerator.model.UpdateCustomRoutingAcceleratorResponse(
        accelerator.map(value => value.asEditable)
      )
    def accelerator: Option[
      zio.aws.globalaccelerator.model.CustomRoutingAccelerator.ReadOnly
    ]
    def getAccelerator: ZIO[
      Any,
      AwsError,
      zio.aws.globalaccelerator.model.CustomRoutingAccelerator.ReadOnly
    ] = AwsError.unwrapOptionField("accelerator", accelerator)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorResponse
  ) extends zio.aws.globalaccelerator.model.UpdateCustomRoutingAcceleratorResponse.ReadOnly {
    override val accelerator: Option[
      zio.aws.globalaccelerator.model.CustomRoutingAccelerator.ReadOnly
    ] = scala
      .Option(impl.accelerator())
      .map(value =>
        zio.aws.globalaccelerator.model.CustomRoutingAccelerator.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorResponse
  ): zio.aws.globalaccelerator.model.UpdateCustomRoutingAcceleratorResponse.ReadOnly =
    new Wrapper(impl)
}
