package zio.aws.globalaccelerator.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.globalaccelerator.model.primitives.PortNumber
import scala.jdk.CollectionConverters._
final case class PortOverride(
    listenerPort: Option[PortNumber] = None,
    endpointPort: Option[PortNumber] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.PortOverride = {
    import PortOverride.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.PortOverride
      .builder()
      .optionallyWith(
        listenerPort.map(value => PortNumber.unwrap(value): Integer)
      )(_.listenerPort)
      .optionallyWith(
        endpointPort.map(value => PortNumber.unwrap(value): Integer)
      )(_.endpointPort)
      .build()
  }
  def asReadOnly: zio.aws.globalaccelerator.model.PortOverride.ReadOnly =
    zio.aws.globalaccelerator.model.PortOverride.wrap(buildAwsValue())
}
object PortOverride {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.PortOverride
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.PortOverride =
      zio.aws.globalaccelerator.model.PortOverride(
        listenerPort.map(value => value),
        endpointPort.map(value => value)
      )
    def listenerPort: Option[PortNumber]
    def endpointPort: Option[PortNumber]
    def getListenerPort: ZIO[Any, AwsError, PortNumber] =
      AwsError.unwrapOptionField("listenerPort", listenerPort)
    def getEndpointPort: ZIO[Any, AwsError, PortNumber] =
      AwsError.unwrapOptionField("endpointPort", endpointPort)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.PortOverride
  ) extends zio.aws.globalaccelerator.model.PortOverride.ReadOnly {
    override val listenerPort: Option[PortNumber] = scala
      .Option(impl.listenerPort())
      .map(value =>
        zio.aws.globalaccelerator.model.primitives.PortNumber(value)
      )
    override val endpointPort: Option[PortNumber] = scala
      .Option(impl.endpointPort())
      .map(value =>
        zio.aws.globalaccelerator.model.primitives.PortNumber(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.PortOverride
  ): zio.aws.globalaccelerator.model.PortOverride.ReadOnly = new Wrapper(impl)
}
