package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class DescribeCustomRoutingEndpointGroupRequest(
    endpointGroupArn: GenericString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingEndpointGroupRequest = {
    import DescribeCustomRoutingEndpointGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingEndpointGroupRequest
      .builder()
      .endpointGroupArn(
        GenericString.unwrap(endpointGroupArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.DescribeCustomRoutingEndpointGroupRequest.ReadOnly =
    zio.aws.globalaccelerator.model.DescribeCustomRoutingEndpointGroupRequest
      .wrap(buildAwsValue())
}
object DescribeCustomRoutingEndpointGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingEndpointGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.DescribeCustomRoutingEndpointGroupRequest =
      zio.aws.globalaccelerator.model
        .DescribeCustomRoutingEndpointGroupRequest(endpointGroupArn)
    def endpointGroupArn: GenericString
    def getEndpointGroupArn: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(endpointGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingEndpointGroupRequest
  ) extends zio.aws.globalaccelerator.model.DescribeCustomRoutingEndpointGroupRequest.ReadOnly {
    override val endpointGroupArn: GenericString =
      zio.aws.globalaccelerator.model.primitives
        .GenericString(impl.endpointGroupArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingEndpointGroupRequest
  ): zio.aws.globalaccelerator.model.DescribeCustomRoutingEndpointGroupRequest.ReadOnly =
    new Wrapper(impl)
}
