package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class CustomRoutingListener(
    listenerArn: Option[GenericString] = None,
    portRanges: Option[Iterable[zio.aws.globalaccelerator.model.PortRange]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingListener = {
    import CustomRoutingListener.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingListener
      .builder()
      .optionallyWith(
        listenerArn.map(value => GenericString.unwrap(value): java.lang.String)
      )(_.listenerArn)
      .optionallyWith(
        portRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.portRanges)
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.CustomRoutingListener.ReadOnly =
    zio.aws.globalaccelerator.model.CustomRoutingListener.wrap(buildAwsValue())
}
object CustomRoutingListener {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingListener
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.CustomRoutingListener =
      zio.aws.globalaccelerator.model.CustomRoutingListener(
        listenerArn.map(value => value),
        portRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def listenerArn: Option[GenericString]
    def portRanges
        : Option[List[zio.aws.globalaccelerator.model.PortRange.ReadOnly]]
    def getListenerArn: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("listenerArn", listenerArn)
    def getPortRanges: ZIO[Any, AwsError, List[
      zio.aws.globalaccelerator.model.PortRange.ReadOnly
    ]] = AwsError.unwrapOptionField("portRanges", portRanges)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingListener
  ) extends zio.aws.globalaccelerator.model.CustomRoutingListener.ReadOnly {
    override val listenerArn: Option[GenericString] = scala
      .Option(impl.listenerArn())
      .map(value =>
        zio.aws.globalaccelerator.model.primitives.GenericString(value)
      )
    override val portRanges
        : Option[List[zio.aws.globalaccelerator.model.PortRange.ReadOnly]] =
      scala
        .Option(impl.portRanges())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.globalaccelerator.model.PortRange.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingListener
  ): zio.aws.globalaccelerator.model.CustomRoutingListener.ReadOnly =
    new Wrapper(impl)
}
