package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateEndpointGroupResponse(
    endpointGroup: Option[zio.aws.globalaccelerator.model.EndpointGroup] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.CreateEndpointGroupResponse = {
    import CreateEndpointGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.CreateEndpointGroupResponse
      .builder()
      .optionallyWith(endpointGroup.map(value => value.buildAwsValue()))(
        _.endpointGroup
      )
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.CreateEndpointGroupResponse.ReadOnly =
    zio.aws.globalaccelerator.model.CreateEndpointGroupResponse
      .wrap(buildAwsValue())
}
object CreateEndpointGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.CreateEndpointGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.CreateEndpointGroupResponse =
      zio.aws.globalaccelerator.model.CreateEndpointGroupResponse(
        endpointGroup.map(value => value.asEditable)
      )
    def endpointGroup
        : Option[zio.aws.globalaccelerator.model.EndpointGroup.ReadOnly]
    def getEndpointGroup: ZIO[
      Any,
      AwsError,
      zio.aws.globalaccelerator.model.EndpointGroup.ReadOnly
    ] = AwsError.unwrapOptionField("endpointGroup", endpointGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.CreateEndpointGroupResponse
  ) extends zio.aws.globalaccelerator.model.CreateEndpointGroupResponse.ReadOnly {
    override val endpointGroup
        : Option[zio.aws.globalaccelerator.model.EndpointGroup.ReadOnly] = scala
      .Option(impl.endpointGroup())
      .map(value => zio.aws.globalaccelerator.model.EndpointGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.CreateEndpointGroupResponse
  ): zio.aws.globalaccelerator.model.CreateEndpointGroupResponse.ReadOnly =
    new Wrapper(impl)
}
