package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class UpdateCustomRoutingListenerRequest(
    listenerArn: GenericString,
    portRanges: Iterable[zio.aws.globalaccelerator.model.PortRange]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingListenerRequest = {
    import UpdateCustomRoutingListenerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingListenerRequest
      .builder()
      .listenerArn(GenericString.unwrap(listenerArn): java.lang.String)
      .portRanges(portRanges.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.UpdateCustomRoutingListenerRequest.ReadOnly =
    zio.aws.globalaccelerator.model.UpdateCustomRoutingListenerRequest
      .wrap(buildAwsValue())
}
object UpdateCustomRoutingListenerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingListenerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.UpdateCustomRoutingListenerRequest =
      zio.aws.globalaccelerator.model.UpdateCustomRoutingListenerRequest(
        listenerArn,
        portRanges.map { item =>
          item.asEditable
        }
      )
    def listenerArn: GenericString
    def portRanges: List[zio.aws.globalaccelerator.model.PortRange.ReadOnly]
    def getListenerArn: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(listenerArn)
    def getPortRanges: ZIO[Any, Nothing, List[
      zio.aws.globalaccelerator.model.PortRange.ReadOnly
    ]] = ZIO.succeed(portRanges)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingListenerRequest
  ) extends zio.aws.globalaccelerator.model.UpdateCustomRoutingListenerRequest.ReadOnly {
    override val listenerArn: GenericString =
      zio.aws.globalaccelerator.model.primitives
        .GenericString(impl.listenerArn())
    override val portRanges
        : List[zio.aws.globalaccelerator.model.PortRange.ReadOnly] = impl
      .portRanges()
      .asScala
      .map { item =>
        zio.aws.globalaccelerator.model.PortRange.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingListenerRequest
  ): zio.aws.globalaccelerator.model.UpdateCustomRoutingListenerRequest.ReadOnly =
    new Wrapper(impl)
}
