package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateCustomRoutingAcceleratorAttributesResponse(
    acceleratorAttributes: Option[
      zio.aws.globalaccelerator.model.CustomRoutingAcceleratorAttributes
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorAttributesResponse = {
    import UpdateCustomRoutingAcceleratorAttributesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorAttributesResponse
      .builder()
      .optionallyWith(
        acceleratorAttributes.map(value => value.buildAwsValue())
      )(_.acceleratorAttributes)
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.UpdateCustomRoutingAcceleratorAttributesResponse.ReadOnly =
    zio.aws.globalaccelerator.model.UpdateCustomRoutingAcceleratorAttributesResponse
      .wrap(buildAwsValue())
}
object UpdateCustomRoutingAcceleratorAttributesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorAttributesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.UpdateCustomRoutingAcceleratorAttributesResponse =
      zio.aws.globalaccelerator.model
        .UpdateCustomRoutingAcceleratorAttributesResponse(
          acceleratorAttributes.map(value => value.asEditable)
        )
    def acceleratorAttributes: Option[
      zio.aws.globalaccelerator.model.CustomRoutingAcceleratorAttributes.ReadOnly
    ]
    def getAcceleratorAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.globalaccelerator.model.CustomRoutingAcceleratorAttributes.ReadOnly
    ] =
      AwsError.unwrapOptionField("acceleratorAttributes", acceleratorAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorAttributesResponse
  ) extends zio.aws.globalaccelerator.model.UpdateCustomRoutingAcceleratorAttributesResponse.ReadOnly {
    override val acceleratorAttributes: Option[
      zio.aws.globalaccelerator.model.CustomRoutingAcceleratorAttributes.ReadOnly
    ] = scala
      .Option(impl.acceleratorAttributes())
      .map(value =>
        zio.aws.globalaccelerator.model.CustomRoutingAcceleratorAttributes
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorAttributesResponse
  ): zio.aws.globalaccelerator.model.UpdateCustomRoutingAcceleratorAttributesResponse.ReadOnly =
    new Wrapper(impl)
}
