package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class ListListenersResponse(
    listeners: Option[Iterable[zio.aws.globalaccelerator.model.Listener]] =
      None,
    nextToken: Option[GenericString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.ListListenersResponse = {
    import ListListenersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.ListListenersResponse
      .builder()
      .optionallyWith(
        listeners.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.listeners)
      .optionallyWith(
        nextToken.map(value => GenericString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.ListListenersResponse.ReadOnly =
    zio.aws.globalaccelerator.model.ListListenersResponse.wrap(buildAwsValue())
}
object ListListenersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.ListListenersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.ListListenersResponse =
      zio.aws.globalaccelerator.model.ListListenersResponse(
        listeners.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def listeners
        : Option[List[zio.aws.globalaccelerator.model.Listener.ReadOnly]]
    def nextToken: Option[GenericString]
    def getListeners: ZIO[Any, AwsError, List[
      zio.aws.globalaccelerator.model.Listener.ReadOnly
    ]] = AwsError.unwrapOptionField("listeners", listeners)
    def getNextToken: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ListListenersResponse
  ) extends zio.aws.globalaccelerator.model.ListListenersResponse.ReadOnly {
    override val listeners
        : Option[List[zio.aws.globalaccelerator.model.Listener.ReadOnly]] =
      scala
        .Option(impl.listeners())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.globalaccelerator.model.Listener.wrap(item)
          }.toList
        )
    override val nextToken: Option[GenericString] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.globalaccelerator.model.primitives.GenericString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ListListenersResponse
  ): zio.aws.globalaccelerator.model.ListListenersResponse.ReadOnly =
    new Wrapper(impl)
}
