package zio.aws.globalaccelerator.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.globalaccelerator.model.primitives.{MaxResults, GenericString}
import scala.jdk.CollectionConverters._
final case class ListEndpointGroupsRequest(
    listenerArn: GenericString,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[GenericString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.ListEndpointGroupsRequest = {
    import ListEndpointGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.ListEndpointGroupsRequest
      .builder()
      .listenerArn(GenericString.unwrap(listenerArn): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => GenericString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.ListEndpointGroupsRequest.ReadOnly =
    zio.aws.globalaccelerator.model.ListEndpointGroupsRequest
      .wrap(buildAwsValue())
}
object ListEndpointGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.ListEndpointGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.ListEndpointGroupsRequest =
      zio.aws.globalaccelerator.model.ListEndpointGroupsRequest(
        listenerArn,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def listenerArn: GenericString
    def maxResults: Option[MaxResults]
    def nextToken: Option[GenericString]
    def getListenerArn: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(listenerArn)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ListEndpointGroupsRequest
  ) extends zio.aws.globalaccelerator.model.ListEndpointGroupsRequest.ReadOnly {
    override val listenerArn: GenericString =
      zio.aws.globalaccelerator.model.primitives
        .GenericString(impl.listenerArn())
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.globalaccelerator.model.primitives.MaxResults(value)
      )
    override val nextToken: Option[GenericString] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.globalaccelerator.model.primitives.GenericString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ListEndpointGroupsRequest
  ): zio.aws.globalaccelerator.model.ListEndpointGroupsRequest.ReadOnly =
    new Wrapper(impl)
}
