package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class ListCustomRoutingEndpointGroupsResponse(
    endpointGroups: Option[
      Iterable[zio.aws.globalaccelerator.model.CustomRoutingEndpointGroup]
    ] = None,
    nextToken: Option[GenericString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsResponse = {
    import ListCustomRoutingEndpointGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsResponse
      .builder()
      .optionallyWith(
        endpointGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.endpointGroups)
      .optionallyWith(
        nextToken.map(value => GenericString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.ListCustomRoutingEndpointGroupsResponse.ReadOnly =
    zio.aws.globalaccelerator.model.ListCustomRoutingEndpointGroupsResponse
      .wrap(buildAwsValue())
}
object ListCustomRoutingEndpointGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.ListCustomRoutingEndpointGroupsResponse =
      zio.aws.globalaccelerator.model.ListCustomRoutingEndpointGroupsResponse(
        endpointGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def endpointGroups: Option[
      List[zio.aws.globalaccelerator.model.CustomRoutingEndpointGroup.ReadOnly]
    ]
    def nextToken: Option[GenericString]
    def getEndpointGroups: ZIO[Any, AwsError, List[
      zio.aws.globalaccelerator.model.CustomRoutingEndpointGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("endpointGroups", endpointGroups)
    def getNextToken: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsResponse
  ) extends zio.aws.globalaccelerator.model.ListCustomRoutingEndpointGroupsResponse.ReadOnly {
    override val endpointGroups: Option[
      List[zio.aws.globalaccelerator.model.CustomRoutingEndpointGroup.ReadOnly]
    ] = scala
      .Option(impl.endpointGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.globalaccelerator.model.CustomRoutingEndpointGroup.wrap(item)
        }.toList
      )
    override val nextToken: Option[GenericString] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.globalaccelerator.model.primitives.GenericString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsResponse
  ): zio.aws.globalaccelerator.model.ListCustomRoutingEndpointGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
