package zio.aws.globalaccelerator.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.globalaccelerator.model.primitives.{
  GenericBoolean,
  EndpointWeight,
  GenericString
}
import scala.jdk.CollectionConverters._
final case class EndpointConfiguration(
    endpointId: Option[GenericString] = None,
    weight: Option[EndpointWeight] = None,
    clientIPPreservationEnabled: Option[GenericBoolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.EndpointConfiguration = {
    import EndpointConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.EndpointConfiguration
      .builder()
      .optionallyWith(
        endpointId.map(value => GenericString.unwrap(value): java.lang.String)
      )(_.endpointId)
      .optionallyWith(
        weight.map(value => EndpointWeight.unwrap(value): Integer)
      )(_.weight)
      .optionallyWith(
        clientIPPreservationEnabled.map(value =>
          GenericBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.clientIPPreservationEnabled)
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.EndpointConfiguration.ReadOnly =
    zio.aws.globalaccelerator.model.EndpointConfiguration.wrap(buildAwsValue())
}
object EndpointConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.EndpointConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.EndpointConfiguration =
      zio.aws.globalaccelerator.model.EndpointConfiguration(
        endpointId.map(value => value),
        weight.map(value => value),
        clientIPPreservationEnabled.map(value => value)
      )
    def endpointId: Option[GenericString]
    def weight: Option[EndpointWeight]
    def clientIPPreservationEnabled: Option[GenericBoolean]
    def getEndpointId: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("endpointId", endpointId)
    def getWeight: ZIO[Any, AwsError, EndpointWeight] =
      AwsError.unwrapOptionField("weight", weight)
    def getClientIPPreservationEnabled: ZIO[Any, AwsError, GenericBoolean] =
      AwsError.unwrapOptionField(
        "clientIPPreservationEnabled",
        clientIPPreservationEnabled
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.EndpointConfiguration
  ) extends zio.aws.globalaccelerator.model.EndpointConfiguration.ReadOnly {
    override val endpointId: Option[GenericString] = scala
      .Option(impl.endpointId())
      .map(value =>
        zio.aws.globalaccelerator.model.primitives.GenericString(value)
      )
    override val weight: Option[EndpointWeight] = scala
      .Option(impl.weight())
      .map(value =>
        zio.aws.globalaccelerator.model.primitives.EndpointWeight(value)
      )
    override val clientIPPreservationEnabled: Option[GenericBoolean] = scala
      .Option(impl.clientIPPreservationEnabled())
      .map(value =>
        zio.aws.globalaccelerator.model.primitives.GenericBoolean(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.EndpointConfiguration
  ): zio.aws.globalaccelerator.model.EndpointConfiguration.ReadOnly =
    new Wrapper(impl)
}
