package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class DestinationPortMapping(
    acceleratorArn: Option[GenericString] = None,
    acceleratorSocketAddresses: Option[
      Iterable[zio.aws.globalaccelerator.model.SocketAddress]
    ] = None,
    endpointGroupArn: Option[GenericString] = None,
    endpointId: Option[GenericString] = None,
    endpointGroupRegion: Option[GenericString] = None,
    destinationSocketAddress: Option[
      zio.aws.globalaccelerator.model.SocketAddress
    ] = None,
    ipAddressType: Option[zio.aws.globalaccelerator.model.IpAddressType] = None,
    destinationTrafficState: Option[
      zio.aws.globalaccelerator.model.CustomRoutingDestinationTrafficState
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.DestinationPortMapping = {
    import DestinationPortMapping.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.DestinationPortMapping
      .builder()
      .optionallyWith(
        acceleratorArn.map(value =>
          GenericString.unwrap(value): java.lang.String
        )
      )(_.acceleratorArn)
      .optionallyWith(
        acceleratorSocketAddresses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.acceleratorSocketAddresses)
      .optionallyWith(
        endpointGroupArn.map(value =>
          GenericString.unwrap(value): java.lang.String
        )
      )(_.endpointGroupArn)
      .optionallyWith(
        endpointId.map(value => GenericString.unwrap(value): java.lang.String)
      )(_.endpointId)
      .optionallyWith(
        endpointGroupRegion.map(value =>
          GenericString.unwrap(value): java.lang.String
        )
      )(_.endpointGroupRegion)
      .optionallyWith(
        destinationSocketAddress.map(value => value.buildAwsValue())
      )(_.destinationSocketAddress)
      .optionallyWith(ipAddressType.map(value => value.unwrap))(_.ipAddressType)
      .optionallyWith(destinationTrafficState.map(value => value.unwrap))(
        _.destinationTrafficState
      )
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.DestinationPortMapping.ReadOnly =
    zio.aws.globalaccelerator.model.DestinationPortMapping.wrap(buildAwsValue())
}
object DestinationPortMapping {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.DestinationPortMapping
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.DestinationPortMapping =
      zio.aws.globalaccelerator.model.DestinationPortMapping(
        acceleratorArn.map(value => value),
        acceleratorSocketAddresses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        endpointGroupArn.map(value => value),
        endpointId.map(value => value),
        endpointGroupRegion.map(value => value),
        destinationSocketAddress.map(value => value.asEditable),
        ipAddressType.map(value => value),
        destinationTrafficState.map(value => value)
      )
    def acceleratorArn: Option[GenericString]
    def acceleratorSocketAddresses
        : Option[List[zio.aws.globalaccelerator.model.SocketAddress.ReadOnly]]
    def endpointGroupArn: Option[GenericString]
    def endpointId: Option[GenericString]
    def endpointGroupRegion: Option[GenericString]
    def destinationSocketAddress
        : Option[zio.aws.globalaccelerator.model.SocketAddress.ReadOnly]
    def ipAddressType: Option[zio.aws.globalaccelerator.model.IpAddressType]
    def destinationTrafficState: Option[
      zio.aws.globalaccelerator.model.CustomRoutingDestinationTrafficState
    ]
    def getAcceleratorArn: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("acceleratorArn", acceleratorArn)
    def getAcceleratorSocketAddresses: ZIO[Any, AwsError, List[
      zio.aws.globalaccelerator.model.SocketAddress.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "acceleratorSocketAddresses",
      acceleratorSocketAddresses
    )
    def getEndpointGroupArn: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("endpointGroupArn", endpointGroupArn)
    def getEndpointId: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("endpointId", endpointId)
    def getEndpointGroupRegion: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("endpointGroupRegion", endpointGroupRegion)
    def getDestinationSocketAddress: ZIO[
      Any,
      AwsError,
      zio.aws.globalaccelerator.model.SocketAddress.ReadOnly
    ] = AwsError.unwrapOptionField(
      "destinationSocketAddress",
      destinationSocketAddress
    )
    def getIpAddressType
        : ZIO[Any, AwsError, zio.aws.globalaccelerator.model.IpAddressType] =
      AwsError.unwrapOptionField("ipAddressType", ipAddressType)
    def getDestinationTrafficState: ZIO[
      Any,
      AwsError,
      zio.aws.globalaccelerator.model.CustomRoutingDestinationTrafficState
    ] = AwsError.unwrapOptionField(
      "destinationTrafficState",
      destinationTrafficState
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DestinationPortMapping
  ) extends zio.aws.globalaccelerator.model.DestinationPortMapping.ReadOnly {
    override val acceleratorArn: Option[GenericString] = scala
      .Option(impl.acceleratorArn())
      .map(value =>
        zio.aws.globalaccelerator.model.primitives.GenericString(value)
      )
    override val acceleratorSocketAddresses
        : Option[List[zio.aws.globalaccelerator.model.SocketAddress.ReadOnly]] =
      scala
        .Option(impl.acceleratorSocketAddresses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.globalaccelerator.model.SocketAddress.wrap(item)
          }.toList
        )
    override val endpointGroupArn: Option[GenericString] = scala
      .Option(impl.endpointGroupArn())
      .map(value =>
        zio.aws.globalaccelerator.model.primitives.GenericString(value)
      )
    override val endpointId: Option[GenericString] = scala
      .Option(impl.endpointId())
      .map(value =>
        zio.aws.globalaccelerator.model.primitives.GenericString(value)
      )
    override val endpointGroupRegion: Option[GenericString] = scala
      .Option(impl.endpointGroupRegion())
      .map(value =>
        zio.aws.globalaccelerator.model.primitives.GenericString(value)
      )
    override val destinationSocketAddress
        : Option[zio.aws.globalaccelerator.model.SocketAddress.ReadOnly] = scala
      .Option(impl.destinationSocketAddress())
      .map(value => zio.aws.globalaccelerator.model.SocketAddress.wrap(value))
    override val ipAddressType
        : Option[zio.aws.globalaccelerator.model.IpAddressType] = scala
      .Option(impl.ipAddressType())
      .map(value => zio.aws.globalaccelerator.model.IpAddressType.wrap(value))
    override val destinationTrafficState: Option[
      zio.aws.globalaccelerator.model.CustomRoutingDestinationTrafficState
    ] = scala
      .Option(impl.destinationTrafficState())
      .map(value =>
        zio.aws.globalaccelerator.model.CustomRoutingDestinationTrafficState
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DestinationPortMapping
  ): zio.aws.globalaccelerator.model.DestinationPortMapping.ReadOnly =
    new Wrapper(impl)
}
