package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class DescribeListenerRequest(listenerArn: GenericString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.DescribeListenerRequest = {
    import DescribeListenerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.DescribeListenerRequest
      .builder()
      .listenerArn(GenericString.unwrap(listenerArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.DescribeListenerRequest.ReadOnly =
    zio.aws.globalaccelerator.model.DescribeListenerRequest
      .wrap(buildAwsValue())
}
object DescribeListenerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.DescribeListenerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.DescribeListenerRequest =
      zio.aws.globalaccelerator.model.DescribeListenerRequest(listenerArn)
    def listenerArn: GenericString
    def getListenerArn: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(listenerArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DescribeListenerRequest
  ) extends zio.aws.globalaccelerator.model.DescribeListenerRequest.ReadOnly {
    override val listenerArn: GenericString =
      zio.aws.globalaccelerator.model.primitives
        .GenericString(impl.listenerArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DescribeListenerRequest
  ): zio.aws.globalaccelerator.model.DescribeListenerRequest.ReadOnly =
    new Wrapper(impl)
}
