package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class DeprovisionByoipCidrRequest(cidr: GenericString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.DeprovisionByoipCidrRequest = {
    import DeprovisionByoipCidrRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.DeprovisionByoipCidrRequest
      .builder()
      .cidr(GenericString.unwrap(cidr): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.DeprovisionByoipCidrRequest.ReadOnly =
    zio.aws.globalaccelerator.model.DeprovisionByoipCidrRequest
      .wrap(buildAwsValue())
}
object DeprovisionByoipCidrRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.DeprovisionByoipCidrRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.DeprovisionByoipCidrRequest =
      zio.aws.globalaccelerator.model.DeprovisionByoipCidrRequest(cidr)
    def cidr: GenericString
    def getCidr: ZIO[Any, Nothing, GenericString] = ZIO.succeed(cidr)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DeprovisionByoipCidrRequest
  ) extends zio.aws.globalaccelerator.model.DeprovisionByoipCidrRequest.ReadOnly {
    override val cidr: GenericString =
      zio.aws.globalaccelerator.model.primitives.GenericString(impl.cidr())
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DeprovisionByoipCidrRequest
  ): zio.aws.globalaccelerator.model.DeprovisionByoipCidrRequest.ReadOnly =
    new Wrapper(impl)
}
