package zio.aws.globalaccelerator.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.globalaccelerator.model.primitives.{
  GenericBoolean,
  PortNumber,
  IpAddress,
  GenericString
}
import scala.jdk.CollectionConverters._
final case class DenyCustomRoutingTrafficRequest(
    endpointGroupArn: GenericString,
    endpointId: GenericString,
    destinationAddresses: Option[Iterable[IpAddress]] = None,
    destinationPorts: Option[Iterable[PortNumber]] = None,
    denyAllTrafficToEndpoint: Option[GenericBoolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.DenyCustomRoutingTrafficRequest = {
    import DenyCustomRoutingTrafficRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.DenyCustomRoutingTrafficRequest
      .builder()
      .endpointGroupArn(
        GenericString.unwrap(endpointGroupArn): java.lang.String
      )
      .endpointId(GenericString.unwrap(endpointId): java.lang.String)
      .optionallyWith(
        destinationAddresses.map(value =>
          value.map { item =>
            IpAddress.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.destinationAddresses)
      .optionallyWith(
        destinationPorts.map(value =>
          value.map { item =>
            PortNumber.unwrap(item): Integer
          }.asJavaCollection
        )
      )(_.destinationPorts)
      .optionallyWith(
        denyAllTrafficToEndpoint.map(value =>
          GenericBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.denyAllTrafficToEndpoint)
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.DenyCustomRoutingTrafficRequest.ReadOnly =
    zio.aws.globalaccelerator.model.DenyCustomRoutingTrafficRequest
      .wrap(buildAwsValue())
}
object DenyCustomRoutingTrafficRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.DenyCustomRoutingTrafficRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.DenyCustomRoutingTrafficRequest =
      zio.aws.globalaccelerator.model.DenyCustomRoutingTrafficRequest(
        endpointGroupArn,
        endpointId,
        destinationAddresses.map(value => value),
        destinationPorts.map(value => value),
        denyAllTrafficToEndpoint.map(value => value)
      )
    def endpointGroupArn: GenericString
    def endpointId: GenericString
    def destinationAddresses: Option[List[IpAddress]]
    def destinationPorts: Option[List[PortNumber]]
    def denyAllTrafficToEndpoint: Option[GenericBoolean]
    def getEndpointGroupArn: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(endpointGroupArn)
    def getEndpointId: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(endpointId)
    def getDestinationAddresses: ZIO[Any, AwsError, List[IpAddress]] =
      AwsError.unwrapOptionField("destinationAddresses", destinationAddresses)
    def getDestinationPorts: ZIO[Any, AwsError, List[PortNumber]] =
      AwsError.unwrapOptionField("destinationPorts", destinationPorts)
    def getDenyAllTrafficToEndpoint: ZIO[Any, AwsError, GenericBoolean] =
      AwsError.unwrapOptionField(
        "denyAllTrafficToEndpoint",
        denyAllTrafficToEndpoint
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DenyCustomRoutingTrafficRequest
  ) extends zio.aws.globalaccelerator.model.DenyCustomRoutingTrafficRequest.ReadOnly {
    override val endpointGroupArn: GenericString =
      zio.aws.globalaccelerator.model.primitives
        .GenericString(impl.endpointGroupArn())
    override val endpointId: GenericString =
      zio.aws.globalaccelerator.model.primitives
        .GenericString(impl.endpointId())
    override val destinationAddresses: Option[List[IpAddress]] = scala
      .Option(impl.destinationAddresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.globalaccelerator.model.primitives.IpAddress(item)
        }.toList
      )
    override val destinationPorts: Option[List[PortNumber]] = scala
      .Option(impl.destinationPorts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.globalaccelerator.model.primitives.PortNumber(item)
        }.toList
      )
    override val denyAllTrafficToEndpoint: Option[GenericBoolean] = scala
      .Option(impl.denyAllTrafficToEndpoint())
      .map(value =>
        zio.aws.globalaccelerator.model.primitives.GenericBoolean(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DenyCustomRoutingTrafficRequest
  ): zio.aws.globalaccelerator.model.DenyCustomRoutingTrafficRequest.ReadOnly =
    new Wrapper(impl)
}
