package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class DeleteListenerRequest(listenerArn: GenericString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.DeleteListenerRequest = {
    import DeleteListenerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.DeleteListenerRequest
      .builder()
      .listenerArn(GenericString.unwrap(listenerArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.DeleteListenerRequest.ReadOnly =
    zio.aws.globalaccelerator.model.DeleteListenerRequest.wrap(buildAwsValue())
}
object DeleteListenerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.DeleteListenerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.DeleteListenerRequest =
      zio.aws.globalaccelerator.model.DeleteListenerRequest(listenerArn)
    def listenerArn: GenericString
    def getListenerArn: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(listenerArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DeleteListenerRequest
  ) extends zio.aws.globalaccelerator.model.DeleteListenerRequest.ReadOnly {
    override val listenerArn: GenericString =
      zio.aws.globalaccelerator.model.primitives
        .GenericString(impl.listenerArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DeleteListenerRequest
  ): zio.aws.globalaccelerator.model.DeleteListenerRequest.ReadOnly =
    new Wrapper(impl)
}
