package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class AddCustomRoutingEndpointsResponse(
    endpointDescriptions: Option[
      Iterable[zio.aws.globalaccelerator.model.CustomRoutingEndpointDescription]
    ] = None,
    endpointGroupArn: Option[GenericString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.AddCustomRoutingEndpointsResponse = {
    import AddCustomRoutingEndpointsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.AddCustomRoutingEndpointsResponse
      .builder()
      .optionallyWith(
        endpointDescriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.endpointDescriptions)
      .optionallyWith(
        endpointGroupArn.map(value =>
          GenericString.unwrap(value): java.lang.String
        )
      )(_.endpointGroupArn)
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.AddCustomRoutingEndpointsResponse.ReadOnly =
    zio.aws.globalaccelerator.model.AddCustomRoutingEndpointsResponse
      .wrap(buildAwsValue())
}
object AddCustomRoutingEndpointsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.AddCustomRoutingEndpointsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.AddCustomRoutingEndpointsResponse =
      zio.aws.globalaccelerator.model.AddCustomRoutingEndpointsResponse(
        endpointDescriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        endpointGroupArn.map(value => value)
      )
    def endpointDescriptions: Option[List[
      zio.aws.globalaccelerator.model.CustomRoutingEndpointDescription.ReadOnly
    ]]
    def endpointGroupArn: Option[GenericString]
    def getEndpointDescriptions: ZIO[Any, AwsError, List[
      zio.aws.globalaccelerator.model.CustomRoutingEndpointDescription.ReadOnly
    ]] =
      AwsError.unwrapOptionField("endpointDescriptions", endpointDescriptions)
    def getEndpointGroupArn: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("endpointGroupArn", endpointGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.AddCustomRoutingEndpointsResponse
  ) extends zio.aws.globalaccelerator.model.AddCustomRoutingEndpointsResponse.ReadOnly {
    override val endpointDescriptions: Option[List[
      zio.aws.globalaccelerator.model.CustomRoutingEndpointDescription.ReadOnly
    ]] = scala
      .Option(impl.endpointDescriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.globalaccelerator.model.CustomRoutingEndpointDescription
            .wrap(item)
        }.toList
      )
    override val endpointGroupArn: Option[GenericString] = scala
      .Option(impl.endpointGroupArn())
      .map(value =>
        zio.aws.globalaccelerator.model.primitives.GenericString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.AddCustomRoutingEndpointsResponse
  ): zio.aws.globalaccelerator.model.AddCustomRoutingEndpointsResponse.ReadOnly =
    new Wrapper(impl)
}
