package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateEndpointGroupResponse(
    endpointGroup: Option[zio.aws.globalaccelerator.model.EndpointGroup] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.UpdateEndpointGroupResponse = {
    import UpdateEndpointGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.UpdateEndpointGroupResponse
      .builder()
      .optionallyWith(endpointGroup.map(value => value.buildAwsValue()))(
        _.endpointGroup
      )
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.UpdateEndpointGroupResponse.ReadOnly =
    zio.aws.globalaccelerator.model.UpdateEndpointGroupResponse
      .wrap(buildAwsValue())
}
object UpdateEndpointGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.UpdateEndpointGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.UpdateEndpointGroupResponse =
      zio.aws.globalaccelerator.model.UpdateEndpointGroupResponse(
        endpointGroup.map(value => value.asEditable)
      )
    def endpointGroup
        : Option[zio.aws.globalaccelerator.model.EndpointGroup.ReadOnly]
    def getEndpointGroup: ZIO[
      Any,
      AwsError,
      zio.aws.globalaccelerator.model.EndpointGroup.ReadOnly
    ] = AwsError.unwrapOptionField("endpointGroup", endpointGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.UpdateEndpointGroupResponse
  ) extends zio.aws.globalaccelerator.model.UpdateEndpointGroupResponse.ReadOnly {
    override val endpointGroup
        : Option[zio.aws.globalaccelerator.model.EndpointGroup.ReadOnly] = scala
      .Option(impl.endpointGroup())
      .map(value => zio.aws.globalaccelerator.model.EndpointGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.UpdateEndpointGroupResponse
  ): zio.aws.globalaccelerator.model.UpdateEndpointGroupResponse.ReadOnly =
    new Wrapper(impl)
}
