package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateCustomRoutingListenerResponse(
    listener: Option[zio.aws.globalaccelerator.model.CustomRoutingListener] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingListenerResponse = {
    import UpdateCustomRoutingListenerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingListenerResponse
      .builder()
      .optionallyWith(listener.map(value => value.buildAwsValue()))(_.listener)
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.UpdateCustomRoutingListenerResponse.ReadOnly =
    zio.aws.globalaccelerator.model.UpdateCustomRoutingListenerResponse
      .wrap(buildAwsValue())
}
object UpdateCustomRoutingListenerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingListenerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.UpdateCustomRoutingListenerResponse =
      zio.aws.globalaccelerator.model.UpdateCustomRoutingListenerResponse(
        listener.map(value => value.asEditable)
      )
    def listener
        : Option[zio.aws.globalaccelerator.model.CustomRoutingListener.ReadOnly]
    def getListener: ZIO[
      Any,
      AwsError,
      zio.aws.globalaccelerator.model.CustomRoutingListener.ReadOnly
    ] = AwsError.unwrapOptionField("listener", listener)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingListenerResponse
  ) extends zio.aws.globalaccelerator.model.UpdateCustomRoutingListenerResponse.ReadOnly {
    override val listener: Option[
      zio.aws.globalaccelerator.model.CustomRoutingListener.ReadOnly
    ] = scala
      .Option(impl.listener())
      .map(value =>
        zio.aws.globalaccelerator.model.CustomRoutingListener.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingListenerResponse
  ): zio.aws.globalaccelerator.model.UpdateCustomRoutingListenerResponse.ReadOnly =
    new Wrapper(impl)
}
