package zio.aws.globalaccelerator.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.globalaccelerator.model.primitives.{PortNumber, GenericString}
import scala.jdk.CollectionConverters._
final case class SocketAddress(
    ipAddress: Option[GenericString] = None,
    port: Option[PortNumber] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.SocketAddress = {
    import SocketAddress.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.SocketAddress
      .builder()
      .optionallyWith(
        ipAddress.map(value => GenericString.unwrap(value): java.lang.String)
      )(_.ipAddress)
      .optionallyWith(port.map(value => PortNumber.unwrap(value): Integer))(
        _.port
      )
      .build()
  }
  def asReadOnly: zio.aws.globalaccelerator.model.SocketAddress.ReadOnly =
    zio.aws.globalaccelerator.model.SocketAddress.wrap(buildAwsValue())
}
object SocketAddress {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.SocketAddress
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.SocketAddress =
      zio.aws.globalaccelerator.model
        .SocketAddress(ipAddress.map(value => value), port.map(value => value))
    def ipAddress: Option[GenericString]
    def port: Option[PortNumber]
    def getIpAddress: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("ipAddress", ipAddress)
    def getPort: ZIO[Any, AwsError, PortNumber] =
      AwsError.unwrapOptionField("port", port)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.SocketAddress
  ) extends zio.aws.globalaccelerator.model.SocketAddress.ReadOnly {
    override val ipAddress: Option[GenericString] = scala
      .Option(impl.ipAddress())
      .map(value =>
        zio.aws.globalaccelerator.model.primitives.GenericString(value)
      )
    override val port: Option[PortNumber] = scala
      .Option(impl.port())
      .map(value =>
        zio.aws.globalaccelerator.model.primitives.PortNumber(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.SocketAddress
  ): zio.aws.globalaccelerator.model.SocketAddress.ReadOnly = new Wrapper(impl)
}
