package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class RemoveCustomRoutingEndpointsRequest(
    endpointIds: Iterable[GenericString],
    endpointGroupArn: GenericString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.RemoveCustomRoutingEndpointsRequest = {
    import RemoveCustomRoutingEndpointsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.RemoveCustomRoutingEndpointsRequest
      .builder()
      .endpointIds(endpointIds.map { item =>
        GenericString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .endpointGroupArn(
        GenericString.unwrap(endpointGroupArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.RemoveCustomRoutingEndpointsRequest.ReadOnly =
    zio.aws.globalaccelerator.model.RemoveCustomRoutingEndpointsRequest
      .wrap(buildAwsValue())
}
object RemoveCustomRoutingEndpointsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.RemoveCustomRoutingEndpointsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.RemoveCustomRoutingEndpointsRequest =
      zio.aws.globalaccelerator.model
        .RemoveCustomRoutingEndpointsRequest(endpointIds, endpointGroupArn)
    def endpointIds: List[GenericString]
    def endpointGroupArn: GenericString
    def getEndpointIds: ZIO[Any, Nothing, List[GenericString]] =
      ZIO.succeed(endpointIds)
    def getEndpointGroupArn: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(endpointGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.RemoveCustomRoutingEndpointsRequest
  ) extends zio.aws.globalaccelerator.model.RemoveCustomRoutingEndpointsRequest.ReadOnly {
    override val endpointIds: List[GenericString] = impl
      .endpointIds()
      .asScala
      .map { item =>
        zio.aws.globalaccelerator.model.primitives.GenericString(item)
      }
      .toList
    override val endpointGroupArn: GenericString =
      zio.aws.globalaccelerator.model.primitives
        .GenericString(impl.endpointGroupArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.RemoveCustomRoutingEndpointsRequest
  ): zio.aws.globalaccelerator.model.RemoveCustomRoutingEndpointsRequest.ReadOnly =
    new Wrapper(impl)
}
