package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class ListCustomRoutingPortMappingsByDestinationResponse(
    destinationPortMappings: Option[
      Iterable[zio.aws.globalaccelerator.model.DestinationPortMapping]
    ] = None,
    nextToken: Option[GenericString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationResponse = {
    import ListCustomRoutingPortMappingsByDestinationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationResponse
      .builder()
      .optionallyWith(
        destinationPortMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.destinationPortMappings)
      .optionallyWith(
        nextToken.map(value => GenericString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationResponse.ReadOnly =
    zio.aws.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationResponse
      .wrap(buildAwsValue())
}
object ListCustomRoutingPortMappingsByDestinationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationResponse =
      zio.aws.globalaccelerator.model
        .ListCustomRoutingPortMappingsByDestinationResponse(
          destinationPortMappings.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          nextToken.map(value => value)
        )
    def destinationPortMappings: Option[
      List[zio.aws.globalaccelerator.model.DestinationPortMapping.ReadOnly]
    ]
    def nextToken: Option[GenericString]
    def getDestinationPortMappings: ZIO[Any, AwsError, List[
      zio.aws.globalaccelerator.model.DestinationPortMapping.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "destinationPortMappings",
      destinationPortMappings
    )
    def getNextToken: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationResponse
  ) extends zio.aws.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationResponse.ReadOnly {
    override val destinationPortMappings: Option[
      List[zio.aws.globalaccelerator.model.DestinationPortMapping.ReadOnly]
    ] = scala
      .Option(impl.destinationPortMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.globalaccelerator.model.DestinationPortMapping.wrap(item)
        }.toList
      )
    override val nextToken: Option[GenericString] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.globalaccelerator.model.primitives.GenericString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationResponse
  ): zio.aws.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationResponse.ReadOnly =
    new Wrapper(impl)
}
