package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeListenerResponse(
    listener: Option[zio.aws.globalaccelerator.model.Listener] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.DescribeListenerResponse = {
    import DescribeListenerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.DescribeListenerResponse
      .builder()
      .optionallyWith(listener.map(value => value.buildAwsValue()))(_.listener)
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.DescribeListenerResponse.ReadOnly =
    zio.aws.globalaccelerator.model.DescribeListenerResponse
      .wrap(buildAwsValue())
}
object DescribeListenerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.DescribeListenerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.DescribeListenerResponse =
      zio.aws.globalaccelerator.model
        .DescribeListenerResponse(listener.map(value => value.asEditable))
    def listener: Option[zio.aws.globalaccelerator.model.Listener.ReadOnly]
    def getListener: ZIO[
      Any,
      AwsError,
      zio.aws.globalaccelerator.model.Listener.ReadOnly
    ] = AwsError.unwrapOptionField("listener", listener)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DescribeListenerResponse
  ) extends zio.aws.globalaccelerator.model.DescribeListenerResponse.ReadOnly {
    override val listener
        : Option[zio.aws.globalaccelerator.model.Listener.ReadOnly] = scala
      .Option(impl.listener())
      .map(value => zio.aws.globalaccelerator.model.Listener.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DescribeListenerResponse
  ): zio.aws.globalaccelerator.model.DescribeListenerResponse.ReadOnly =
    new Wrapper(impl)
}
