package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class DeleteEndpointGroupRequest(endpointGroupArn: GenericString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.DeleteEndpointGroupRequest = {
    import DeleteEndpointGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.DeleteEndpointGroupRequest
      .builder()
      .endpointGroupArn(
        GenericString.unwrap(endpointGroupArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.DeleteEndpointGroupRequest.ReadOnly =
    zio.aws.globalaccelerator.model.DeleteEndpointGroupRequest
      .wrap(buildAwsValue())
}
object DeleteEndpointGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.DeleteEndpointGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.DeleteEndpointGroupRequest =
      zio.aws.globalaccelerator.model
        .DeleteEndpointGroupRequest(endpointGroupArn)
    def endpointGroupArn: GenericString
    def getEndpointGroupArn: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(endpointGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DeleteEndpointGroupRequest
  ) extends zio.aws.globalaccelerator.model.DeleteEndpointGroupRequest.ReadOnly {
    override val endpointGroupArn: GenericString =
      zio.aws.globalaccelerator.model.primitives
        .GenericString(impl.endpointGroupArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DeleteEndpointGroupRequest
  ): zio.aws.globalaccelerator.model.DeleteEndpointGroupRequest.ReadOnly =
    new Wrapper(impl)
}
