package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class DeleteCustomRoutingAcceleratorRequest(
    acceleratorArn: GenericString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.DeleteCustomRoutingAcceleratorRequest = {
    import DeleteCustomRoutingAcceleratorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.DeleteCustomRoutingAcceleratorRequest
      .builder()
      .acceleratorArn(GenericString.unwrap(acceleratorArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.DeleteCustomRoutingAcceleratorRequest.ReadOnly =
    zio.aws.globalaccelerator.model.DeleteCustomRoutingAcceleratorRequest
      .wrap(buildAwsValue())
}
object DeleteCustomRoutingAcceleratorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.DeleteCustomRoutingAcceleratorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.DeleteCustomRoutingAcceleratorRequest =
      zio.aws.globalaccelerator.model
        .DeleteCustomRoutingAcceleratorRequest(acceleratorArn)
    def acceleratorArn: GenericString
    def getAcceleratorArn: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(acceleratorArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DeleteCustomRoutingAcceleratorRequest
  ) extends zio.aws.globalaccelerator.model.DeleteCustomRoutingAcceleratorRequest.ReadOnly {
    override val acceleratorArn: GenericString =
      zio.aws.globalaccelerator.model.primitives
        .GenericString(impl.acceleratorArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.DeleteCustomRoutingAcceleratorRequest
  ): zio.aws.globalaccelerator.model.DeleteCustomRoutingAcceleratorRequest.ReadOnly =
    new Wrapper(impl)
}
