package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.globalaccelerator.model.primitives.{
  IdempotencyToken,
  GenericString
}
import scala.jdk.CollectionConverters._
final case class CreateCustomRoutingEndpointGroupRequest(
    listenerArn: GenericString,
    endpointGroupRegion: GenericString,
    destinationConfigurations: Iterable[
      zio.aws.globalaccelerator.model.CustomRoutingDestinationConfiguration
    ],
    idempotencyToken: IdempotencyToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.CreateCustomRoutingEndpointGroupRequest = {
    import CreateCustomRoutingEndpointGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.CreateCustomRoutingEndpointGroupRequest
      .builder()
      .listenerArn(GenericString.unwrap(listenerArn): java.lang.String)
      .endpointGroupRegion(
        GenericString.unwrap(endpointGroupRegion): java.lang.String
      )
      .destinationConfigurations(destinationConfigurations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .idempotencyToken(
        IdempotencyToken.unwrap(idempotencyToken): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.CreateCustomRoutingEndpointGroupRequest.ReadOnly =
    zio.aws.globalaccelerator.model.CreateCustomRoutingEndpointGroupRequest
      .wrap(buildAwsValue())
}
object CreateCustomRoutingEndpointGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.CreateCustomRoutingEndpointGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.CreateCustomRoutingEndpointGroupRequest =
      zio.aws.globalaccelerator.model.CreateCustomRoutingEndpointGroupRequest(
        listenerArn,
        endpointGroupRegion,
        destinationConfigurations.map { item =>
          item.asEditable
        },
        idempotencyToken
      )
    def listenerArn: GenericString
    def endpointGroupRegion: GenericString
    def destinationConfigurations: List[
      zio.aws.globalaccelerator.model.CustomRoutingDestinationConfiguration.ReadOnly
    ]
    def idempotencyToken: IdempotencyToken
    def getListenerArn: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(listenerArn)
    def getEndpointGroupRegion: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(endpointGroupRegion)
    def getDestinationConfigurations: ZIO[Any, Nothing, List[
      zio.aws.globalaccelerator.model.CustomRoutingDestinationConfiguration.ReadOnly
    ]] = ZIO.succeed(destinationConfigurations)
    def getIdempotencyToken: ZIO[Any, Nothing, IdempotencyToken] =
      ZIO.succeed(idempotencyToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.CreateCustomRoutingEndpointGroupRequest
  ) extends zio.aws.globalaccelerator.model.CreateCustomRoutingEndpointGroupRequest.ReadOnly {
    override val listenerArn: GenericString =
      zio.aws.globalaccelerator.model.primitives
        .GenericString(impl.listenerArn())
    override val endpointGroupRegion: GenericString =
      zio.aws.globalaccelerator.model.primitives
        .GenericString(impl.endpointGroupRegion())
    override val destinationConfigurations: List[
      zio.aws.globalaccelerator.model.CustomRoutingDestinationConfiguration.ReadOnly
    ] = impl
      .destinationConfigurations()
      .asScala
      .map { item =>
        zio.aws.globalaccelerator.model.CustomRoutingDestinationConfiguration
          .wrap(item)
      }
      .toList
    override val idempotencyToken: IdempotencyToken =
      zio.aws.globalaccelerator.model.primitives
        .IdempotencyToken(impl.idempotencyToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.CreateCustomRoutingEndpointGroupRequest
  ): zio.aws.globalaccelerator.model.CreateCustomRoutingEndpointGroupRequest.ReadOnly =
    new Wrapper(impl)
}
