package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AdvertiseByoipCidrResponse(
    byoipCidr: Option[zio.aws.globalaccelerator.model.ByoipCidr] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.AdvertiseByoipCidrResponse = {
    import AdvertiseByoipCidrResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.AdvertiseByoipCidrResponse
      .builder()
      .optionallyWith(byoipCidr.map(value => value.buildAwsValue()))(
        _.byoipCidr
      )
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.AdvertiseByoipCidrResponse.ReadOnly =
    zio.aws.globalaccelerator.model.AdvertiseByoipCidrResponse
      .wrap(buildAwsValue())
}
object AdvertiseByoipCidrResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.AdvertiseByoipCidrResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.AdvertiseByoipCidrResponse =
      zio.aws.globalaccelerator.model
        .AdvertiseByoipCidrResponse(byoipCidr.map(value => value.asEditable))
    def byoipCidr: Option[zio.aws.globalaccelerator.model.ByoipCidr.ReadOnly]
    def getByoipCidr: ZIO[
      Any,
      AwsError,
      zio.aws.globalaccelerator.model.ByoipCidr.ReadOnly
    ] = AwsError.unwrapOptionField("byoipCidr", byoipCidr)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.AdvertiseByoipCidrResponse
  ) extends zio.aws.globalaccelerator.model.AdvertiseByoipCidrResponse.ReadOnly {
    override val byoipCidr
        : Option[zio.aws.globalaccelerator.model.ByoipCidr.ReadOnly] = scala
      .Option(impl.byoipCidr())
      .map(value => zio.aws.globalaccelerator.model.ByoipCidr.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.AdvertiseByoipCidrResponse
  ): zio.aws.globalaccelerator.model.AdvertiseByoipCidrResponse.ReadOnly =
    new Wrapper(impl)
}
