package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.globalaccelerator.model.primitives.GenericString
import scala.jdk.CollectionConverters._
final case class AddCustomRoutingEndpointsRequest(
    endpointConfigurations: Iterable[
      zio.aws.globalaccelerator.model.CustomRoutingEndpointConfiguration
    ],
    endpointGroupArn: GenericString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.AddCustomRoutingEndpointsRequest = {
    import AddCustomRoutingEndpointsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.AddCustomRoutingEndpointsRequest
      .builder()
      .endpointConfigurations(endpointConfigurations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .endpointGroupArn(
        GenericString.unwrap(endpointGroupArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.AddCustomRoutingEndpointsRequest.ReadOnly =
    zio.aws.globalaccelerator.model.AddCustomRoutingEndpointsRequest
      .wrap(buildAwsValue())
}
object AddCustomRoutingEndpointsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.AddCustomRoutingEndpointsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.AddCustomRoutingEndpointsRequest =
      zio.aws.globalaccelerator.model.AddCustomRoutingEndpointsRequest(
        endpointConfigurations.map { item =>
          item.asEditable
        },
        endpointGroupArn
      )
    def endpointConfigurations: List[
      zio.aws.globalaccelerator.model.CustomRoutingEndpointConfiguration.ReadOnly
    ]
    def endpointGroupArn: GenericString
    def getEndpointConfigurations: ZIO[Any, Nothing, List[
      zio.aws.globalaccelerator.model.CustomRoutingEndpointConfiguration.ReadOnly
    ]] = ZIO.succeed(endpointConfigurations)
    def getEndpointGroupArn: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(endpointGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.AddCustomRoutingEndpointsRequest
  ) extends zio.aws.globalaccelerator.model.AddCustomRoutingEndpointsRequest.ReadOnly {
    override val endpointConfigurations: List[
      zio.aws.globalaccelerator.model.CustomRoutingEndpointConfiguration.ReadOnly
    ] = impl
      .endpointConfigurations()
      .asScala
      .map { item =>
        zio.aws.globalaccelerator.model.CustomRoutingEndpointConfiguration
          .wrap(item)
      }
      .toList
    override val endpointGroupArn: GenericString =
      zio.aws.globalaccelerator.model.primitives
        .GenericString(impl.endpointGroupArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.AddCustomRoutingEndpointsRequest
  ): zio.aws.globalaccelerator.model.AddCustomRoutingEndpointsRequest.ReadOnly =
    new Wrapper(impl)
}
