package zio.aws.globalaccelerator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ProvisionByoipCidrResponse(
    byoipCidr: Option[zio.aws.globalaccelerator.model.ByoipCidr] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.ProvisionByoipCidrResponse = {
    import ProvisionByoipCidrResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.ProvisionByoipCidrResponse
      .builder()
      .optionallyWith(byoipCidr.map(value => value.buildAwsValue()))(
        _.byoipCidr
      )
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.ProvisionByoipCidrResponse.ReadOnly =
    zio.aws.globalaccelerator.model.ProvisionByoipCidrResponse
      .wrap(buildAwsValue())
}
object ProvisionByoipCidrResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.ProvisionByoipCidrResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.ProvisionByoipCidrResponse =
      zio.aws.globalaccelerator.model
        .ProvisionByoipCidrResponse(byoipCidr.map(value => value.asEditable))
    def byoipCidr: Option[zio.aws.globalaccelerator.model.ByoipCidr.ReadOnly]
    def getByoipCidr: ZIO[
      Any,
      AwsError,
      zio.aws.globalaccelerator.model.ByoipCidr.ReadOnly
    ] = AwsError.unwrapOptionField("byoipCidr", byoipCidr)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ProvisionByoipCidrResponse
  ) extends zio.aws.globalaccelerator.model.ProvisionByoipCidrResponse.ReadOnly {
    override val byoipCidr
        : Option[zio.aws.globalaccelerator.model.ByoipCidr.ReadOnly] = scala
      .Option(impl.byoipCidr())
      .map(value => zio.aws.globalaccelerator.model.ByoipCidr.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ProvisionByoipCidrResponse
  ): zio.aws.globalaccelerator.model.ProvisionByoipCidrResponse.ReadOnly =
    new Wrapper(impl)
}
