package zio.aws.globalaccelerator.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.globalaccelerator.model.primitives.{
  PortMappingsMaxResults,
  GenericString
}
import scala.jdk.CollectionConverters._
final case class ListCustomRoutingPortMappingsRequest(
    acceleratorArn: GenericString,
    endpointGroupArn: Option[GenericString] = None,
    maxResults: Option[PortMappingsMaxResults] = None,
    nextToken: Option[GenericString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsRequest = {
    import ListCustomRoutingPortMappingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsRequest
      .builder()
      .acceleratorArn(GenericString.unwrap(acceleratorArn): java.lang.String)
      .optionallyWith(
        endpointGroupArn.map(value =>
          GenericString.unwrap(value): java.lang.String
        )
      )(_.endpointGroupArn)
      .optionallyWith(
        maxResults.map(value => PortMappingsMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => GenericString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.ListCustomRoutingPortMappingsRequest.ReadOnly =
    zio.aws.globalaccelerator.model.ListCustomRoutingPortMappingsRequest
      .wrap(buildAwsValue())
}
object ListCustomRoutingPortMappingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.globalaccelerator.model.ListCustomRoutingPortMappingsRequest =
      zio.aws.globalaccelerator.model.ListCustomRoutingPortMappingsRequest(
        acceleratorArn,
        endpointGroupArn.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def acceleratorArn: GenericString
    def endpointGroupArn: Option[GenericString]
    def maxResults: Option[PortMappingsMaxResults]
    def nextToken: Option[GenericString]
    def getAcceleratorArn: ZIO[Any, Nothing, GenericString] =
      ZIO.succeed(acceleratorArn)
    def getEndpointGroupArn: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("endpointGroupArn", endpointGroupArn)
    def getMaxResults: ZIO[Any, AwsError, PortMappingsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsRequest
  ) extends zio.aws.globalaccelerator.model.ListCustomRoutingPortMappingsRequest.ReadOnly {
    override val acceleratorArn: GenericString =
      zio.aws.globalaccelerator.model.primitives
        .GenericString(impl.acceleratorArn())
    override val endpointGroupArn: Option[GenericString] = scala
      .Option(impl.endpointGroupArn())
      .map(value =>
        zio.aws.globalaccelerator.model.primitives.GenericString(value)
      )
    override val maxResults: Option[PortMappingsMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.globalaccelerator.model.primitives.PortMappingsMaxResults(value)
      )
    override val nextToken: Option[GenericString] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.globalaccelerator.model.primitives.GenericString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsRequest
  ): zio.aws.globalaccelerator.model.ListCustomRoutingPortMappingsRequest.ReadOnly =
    new Wrapper(impl)
}
