package zio.aws.globalaccelerator.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.globalaccelerator.model.primitives.{GenericString, MaxResults}
import scala.jdk.CollectionConverters._
final case class ListAcceleratorsRequest(
    maxResults: Option[MaxResults] = None,
    nextToken: Option[GenericString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.globalaccelerator.model.ListAcceleratorsRequest = {
    import ListAcceleratorsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.globalaccelerator.model.ListAcceleratorsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => GenericString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.globalaccelerator.model.ListAcceleratorsRequest.ReadOnly =
    zio.aws.globalaccelerator.model.ListAcceleratorsRequest
      .wrap(buildAwsValue())
}
object ListAcceleratorsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.globalaccelerator.model.ListAcceleratorsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.globalaccelerator.model.ListAcceleratorsRequest =
      zio.aws.globalaccelerator.model.ListAcceleratorsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Option[MaxResults]
    def nextToken: Option[GenericString]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ListAcceleratorsRequest
  ) extends zio.aws.globalaccelerator.model.ListAcceleratorsRequest.ReadOnly {
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.globalaccelerator.model.primitives.MaxResults(value)
      )
    override val nextToken: Option[GenericString] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.globalaccelerator.model.primitives.GenericString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.globalaccelerator.model.ListAcceleratorsRequest
  ): zio.aws.globalaccelerator.model.ListAcceleratorsRequest.ReadOnly =
    new Wrapper(impl)
}
