package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.{
  TimestampEpoch,
  PermissionGroupDescription,
  PermissionGroupName,
  PermissionGroupId
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PermissionGroup(
    permissionGroupId: Optional[PermissionGroupId] = Optional.Absent,
    name: Optional[PermissionGroupName] = Optional.Absent,
    description: Optional[PermissionGroupDescription] = Optional.Absent,
    applicationPermissions: Optional[
      Iterable[zio.aws.finspacedata.model.ApplicationPermission]
    ] = Optional.Absent,
    createTime: Optional[TimestampEpoch] = Optional.Absent,
    lastModifiedTime: Optional[TimestampEpoch] = Optional.Absent,
    membershipStatus: Optional[
      zio.aws.finspacedata.model.PermissionGroupMembershipStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.PermissionGroup = {
    import PermissionGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.PermissionGroup
      .builder()
      .optionallyWith(
        permissionGroupId.map(value =>
          PermissionGroupId.unwrap(value): java.lang.String
        )
      )(_.permissionGroupId)
      .optionallyWith(
        name.map(value => PermissionGroupName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          PermissionGroupDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        applicationPermissions.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.applicationPermissionsWithStrings)
      .optionallyWith(
        createTime.map(value => TimestampEpoch.unwrap(value): java.lang.Long)
      )(_.createTime)
      .optionallyWith(
        lastModifiedTime.map(value =>
          TimestampEpoch.unwrap(value): java.lang.Long
        )
      )(_.lastModifiedTime)
      .optionallyWith(membershipStatus.map(value => value.unwrap))(
        _.membershipStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.PermissionGroup.ReadOnly =
    zio.aws.finspacedata.model.PermissionGroup.wrap(buildAwsValue())
}
object PermissionGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.PermissionGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.PermissionGroup =
      zio.aws.finspacedata.model.PermissionGroup(
        permissionGroupId.map(value => value),
        name.map(value => value),
        description.map(value => value),
        applicationPermissions.map(value => value),
        createTime.map(value => value),
        lastModifiedTime.map(value => value),
        membershipStatus.map(value => value)
      )
    def permissionGroupId: Optional[PermissionGroupId]
    def name: Optional[PermissionGroupName]
    def description: Optional[PermissionGroupDescription]
    def applicationPermissions
        : Optional[List[zio.aws.finspacedata.model.ApplicationPermission]]
    def createTime: Optional[TimestampEpoch]
    def lastModifiedTime: Optional[TimestampEpoch]
    def membershipStatus
        : Optional[zio.aws.finspacedata.model.PermissionGroupMembershipStatus]
    def getPermissionGroupId: ZIO[Any, AwsError, PermissionGroupId] =
      AwsError.unwrapOptionField("permissionGroupId", permissionGroupId)
    def getName: ZIO[Any, AwsError, PermissionGroupName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, PermissionGroupDescription] =
      AwsError.unwrapOptionField("description", description)
    def getApplicationPermissions: ZIO[Any, AwsError, List[
      zio.aws.finspacedata.model.ApplicationPermission
    ]] = AwsError.unwrapOptionField(
      "applicationPermissions",
      applicationPermissions
    )
    def getCreateTime: ZIO[Any, AwsError, TimestampEpoch] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getLastModifiedTime: ZIO[Any, AwsError, TimestampEpoch] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getMembershipStatus: ZIO[
      Any,
      AwsError,
      zio.aws.finspacedata.model.PermissionGroupMembershipStatus
    ] = AwsError.unwrapOptionField("membershipStatus", membershipStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.PermissionGroup
  ) extends zio.aws.finspacedata.model.PermissionGroup.ReadOnly {
    override val permissionGroupId: Optional[PermissionGroupId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.permissionGroupId())
        .map(value =>
          zio.aws.finspacedata.model.primitives.PermissionGroupId(value)
        )
    override val name: Optional[PermissionGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.finspacedata.model.primitives.PermissionGroupName(value)
      )
    override val description: Optional[PermissionGroupDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.finspacedata.model.primitives
            .PermissionGroupDescription(value)
        )
    override val applicationPermissions
        : Optional[List[zio.aws.finspacedata.model.ApplicationPermission]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationPermissions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.finspacedata.model.ApplicationPermission.wrap(item)
          }.toList
        )
    override val createTime: Optional[TimestampEpoch] = zio.aws.core.internal
      .optionalFromNullable(impl.createTime())
      .map(value => zio.aws.finspacedata.model.primitives.TimestampEpoch(value))
    override val lastModifiedTime: Optional[TimestampEpoch] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedTime())
        .map(value =>
          zio.aws.finspacedata.model.primitives.TimestampEpoch(value)
        )
    override val membershipStatus
        : Optional[zio.aws.finspacedata.model.PermissionGroupMembershipStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.membershipStatus())
        .map(value =>
          zio.aws.finspacedata.model.PermissionGroupMembershipStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.PermissionGroup
  ): zio.aws.finspacedata.model.PermissionGroup.ReadOnly = new Wrapper(impl)
}
