package zio.aws.finspacedata.model
import scala.jdk.CollectionConverters.*
sealed trait DatasetStatus {
  def unwrap: software.amazon.awssdk.services.finspacedata.model.DatasetStatus
}
object DatasetStatus {
  def wrap(
      value: software.amazon.awssdk.services.finspacedata.model.DatasetStatus
  ): zio.aws.finspacedata.model.DatasetStatus = value match {
    case software.amazon.awssdk.services.finspacedata.model.DatasetStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.finspacedata.model.DatasetStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.finspacedata.model.DatasetStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.finspacedata.model.DatasetStatus.SUCCESS =>
      val r = SUCCESS
      r
    case software.amazon.awssdk.services.finspacedata.model.DatasetStatus.RUNNING =>
      val r = RUNNING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.finspacedata.model.DatasetStatus {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.DatasetStatus =
      software.amazon.awssdk.services.finspacedata.model.DatasetStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.finspacedata.model.DatasetStatus {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.DatasetStatus =
      software.amazon.awssdk.services.finspacedata.model.DatasetStatus.PENDING
  }
  case object FAILED extends zio.aws.finspacedata.model.DatasetStatus {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.DatasetStatus =
      software.amazon.awssdk.services.finspacedata.model.DatasetStatus.FAILED
  }
  case object SUCCESS extends zio.aws.finspacedata.model.DatasetStatus {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.DatasetStatus =
      software.amazon.awssdk.services.finspacedata.model.DatasetStatus.SUCCESS
  }
  case object RUNNING extends zio.aws.finspacedata.model.DatasetStatus {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.DatasetStatus =
      software.amazon.awssdk.services.finspacedata.model.DatasetStatus.RUNNING
  }
}
