package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.{
  TimestampEpoch,
  StringValueLength1to255,
  DatasetId,
  ClientToken
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateDataViewRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    datasetId: DatasetId,
    autoUpdate: Optional[Boolean] = Optional.Absent,
    sortColumns: Optional[Iterable[StringValueLength1to255]] = Optional.Absent,
    partitionColumns: Optional[Iterable[StringValueLength1to255]] =
      Optional.Absent,
    asOfTimestamp: Optional[TimestampEpoch] = Optional.Absent,
    destinationTypeParams: zio.aws.finspacedata.model.DataViewDestinationTypeParams
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.CreateDataViewRequest = {
    import CreateDataViewRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.CreateDataViewRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .datasetId(DatasetId.unwrap(datasetId): java.lang.String)
      .optionallyWith(autoUpdate.map(value => value: java.lang.Boolean))(
        _.autoUpdate
      )
      .optionallyWith(
        sortColumns.map(value =>
          value.map { item =>
            StringValueLength1to255.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.sortColumns)
      .optionallyWith(
        partitionColumns.map(value =>
          value.map { item =>
            StringValueLength1to255.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.partitionColumns)
      .optionallyWith(
        asOfTimestamp.map(value => TimestampEpoch.unwrap(value): java.lang.Long)
      )(_.asOfTimestamp)
      .destinationTypeParams(destinationTypeParams.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.CreateDataViewRequest.ReadOnly =
    zio.aws.finspacedata.model.CreateDataViewRequest.wrap(buildAwsValue())
}
object CreateDataViewRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.CreateDataViewRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.CreateDataViewRequest =
      zio.aws.finspacedata.model.CreateDataViewRequest(
        clientToken.map(value => value),
        datasetId,
        autoUpdate.map(value => value),
        sortColumns.map(value => value),
        partitionColumns.map(value => value),
        asOfTimestamp.map(value => value),
        destinationTypeParams.asEditable
      )
    def clientToken: Optional[ClientToken]
    def datasetId: DatasetId
    def autoUpdate: Optional[Boolean]
    def sortColumns: Optional[List[StringValueLength1to255]]
    def partitionColumns: Optional[List[StringValueLength1to255]]
    def asOfTimestamp: Optional[TimestampEpoch]
    def destinationTypeParams
        : zio.aws.finspacedata.model.DataViewDestinationTypeParams.ReadOnly
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDatasetId: ZIO[Any, Nothing, DatasetId] = ZIO.succeed(datasetId)
    def getAutoUpdate: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("autoUpdate", autoUpdate)
    def getSortColumns: ZIO[Any, AwsError, List[StringValueLength1to255]] =
      AwsError.unwrapOptionField("sortColumns", sortColumns)
    def getPartitionColumns: ZIO[Any, AwsError, List[StringValueLength1to255]] =
      AwsError.unwrapOptionField("partitionColumns", partitionColumns)
    def getAsOfTimestamp: ZIO[Any, AwsError, TimestampEpoch] =
      AwsError.unwrapOptionField("asOfTimestamp", asOfTimestamp)
    def getDestinationTypeParams: ZIO[
      Any,
      Nothing,
      zio.aws.finspacedata.model.DataViewDestinationTypeParams.ReadOnly
    ] = ZIO.succeed(destinationTypeParams)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.CreateDataViewRequest
  ) extends zio.aws.finspacedata.model.CreateDataViewRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.finspacedata.model.primitives.ClientToken(value))
    override val datasetId: DatasetId =
      zio.aws.finspacedata.model.primitives.DatasetId(impl.datasetId())
    override val autoUpdate: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.autoUpdate())
      .map(value => value: Boolean)
    override val sortColumns: Optional[List[StringValueLength1to255]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortColumns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.finspacedata.model.primitives.StringValueLength1to255(item)
          }.toList
        )
    override val partitionColumns: Optional[List[StringValueLength1to255]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.partitionColumns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.finspacedata.model.primitives.StringValueLength1to255(item)
          }.toList
        )
    override val asOfTimestamp: Optional[TimestampEpoch] = zio.aws.core.internal
      .optionalFromNullable(impl.asOfTimestamp())
      .map(value => zio.aws.finspacedata.model.primitives.TimestampEpoch(value))
    override val destinationTypeParams
        : zio.aws.finspacedata.model.DataViewDestinationTypeParams.ReadOnly =
      zio.aws.finspacedata.model.DataViewDestinationTypeParams
        .wrap(impl.destinationTypeParams())
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.CreateDataViewRequest
  ): zio.aws.finspacedata.model.CreateDataViewRequest.ReadOnly = new Wrapper(
    impl
  )
}
