package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.{ColumnDescription, ColumnName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ColumnDefinition(
    dataType: Optional[zio.aws.finspacedata.model.ColumnDataType] =
      Optional.Absent,
    columnName: Optional[ColumnName] = Optional.Absent,
    columnDescription: Optional[ColumnDescription] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.ColumnDefinition = {
    import ColumnDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.ColumnDefinition
      .builder()
      .optionallyWith(dataType.map(value => value.unwrap))(_.dataType)
      .optionallyWith(
        columnName.map(value => ColumnName.unwrap(value): java.lang.String)
      )(_.columnName)
      .optionallyWith(
        columnDescription.map(value =>
          ColumnDescription.unwrap(value): java.lang.String
        )
      )(_.columnDescription)
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.ColumnDefinition.ReadOnly =
    zio.aws.finspacedata.model.ColumnDefinition.wrap(buildAwsValue())
}
object ColumnDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.ColumnDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.ColumnDefinition =
      zio.aws.finspacedata.model.ColumnDefinition(
        dataType.map(value => value),
        columnName.map(value => value),
        columnDescription.map(value => value)
      )
    def dataType: Optional[zio.aws.finspacedata.model.ColumnDataType]
    def columnName: Optional[ColumnName]
    def columnDescription: Optional[ColumnDescription]
    def getDataType
        : ZIO[Any, AwsError, zio.aws.finspacedata.model.ColumnDataType] =
      AwsError.unwrapOptionField("dataType", dataType)
    def getColumnName: ZIO[Any, AwsError, ColumnName] =
      AwsError.unwrapOptionField("columnName", columnName)
    def getColumnDescription: ZIO[Any, AwsError, ColumnDescription] =
      AwsError.unwrapOptionField("columnDescription", columnDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.ColumnDefinition
  ) extends zio.aws.finspacedata.model.ColumnDefinition.ReadOnly {
    override val dataType: Optional[zio.aws.finspacedata.model.ColumnDataType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataType())
        .map(value => zio.aws.finspacedata.model.ColumnDataType.wrap(value))
    override val columnName: Optional[ColumnName] = zio.aws.core.internal
      .optionalFromNullable(impl.columnName())
      .map(value => zio.aws.finspacedata.model.primitives.ColumnName(value))
    override val columnDescription: Optional[ColumnDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.columnDescription())
        .map(value =>
          zio.aws.finspacedata.model.primitives.ColumnDescription(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.ColumnDefinition
  ): zio.aws.finspacedata.model.ColumnDefinition.ReadOnly = new Wrapper(impl)
}
