package zio.aws.finspacedata
import zio.aws.finspacedata.model.GetProgrammaticAccessCredentialsResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.finspacedata.model.{
  ListChangesetsRequest,
  ListPermissionGroupsRequest,
  CreateDatasetRequest,
  ListPermissionGroupsByUserRequest,
  DeletePermissionGroupRequest,
  EnableUserRequest,
  GetProgrammaticAccessCredentialsRequest,
  ListUsersRequest,
  CreateChangesetRequest,
  GetExternalDataViewAccessDetailsRequest,
  CreatePermissionGroupRequest,
  ListDatasetsRequest,
  CreateUserRequest,
  GetChangesetRequest,
  DeleteDatasetRequest,
  GetUserRequest,
  ListDataViewsRequest,
  ListUsersByPermissionGroupRequest,
  UpdatePermissionGroupRequest,
  CreateDataViewRequest,
  GetDatasetRequest,
  ResetUserPasswordRequest,
  UpdateChangesetRequest,
  UpdateUserRequest,
  GetWorkingLocationRequest,
  DisassociateUserFromPermissionGroupRequest,
  UpdateDatasetRequest,
  GetDataViewRequest,
  DisableUserRequest,
  AssociateUserToPermissionGroupRequest,
  GetPermissionGroupRequest
}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.finspacedata.FinspaceDataAsyncClient
import zio.stream.ZStream
object FinspaceDataMock extends Mock[FinspaceData] {
  object CreateDataset
      extends Effect[
        CreateDatasetRequest,
        AwsError,
        zio.aws.finspacedata.model.CreateDatasetResponse.ReadOnly
      ]
  object GetExternalDataViewAccessDetails
      extends Effect[
        GetExternalDataViewAccessDetailsRequest,
        AwsError,
        zio.aws.finspacedata.model.GetExternalDataViewAccessDetailsResponse.ReadOnly
      ]
  object ListDataViews
      extends Stream[
        ListDataViewsRequest,
        AwsError,
        zio.aws.finspacedata.model.DataViewSummary.ReadOnly
      ]
  object ListDataViewsPaginated
      extends Effect[
        ListDataViewsRequest,
        AwsError,
        zio.aws.finspacedata.model.ListDataViewsResponse.ReadOnly
      ]
  object ListUsers
      extends Stream[
        ListUsersRequest,
        AwsError,
        zio.aws.finspacedata.model.User.ReadOnly
      ]
  object ListUsersPaginated
      extends Effect[
        ListUsersRequest,
        AwsError,
        zio.aws.finspacedata.model.ListUsersResponse.ReadOnly
      ]
  object UpdateUser
      extends Effect[
        UpdateUserRequest,
        AwsError,
        zio.aws.finspacedata.model.UpdateUserResponse.ReadOnly
      ]
  object ListUsersByPermissionGroup
      extends Effect[
        ListUsersByPermissionGroupRequest,
        AwsError,
        zio.aws.finspacedata.model.ListUsersByPermissionGroupResponse.ReadOnly
      ]
  object DisassociateUserFromPermissionGroup
      extends Effect[
        DisassociateUserFromPermissionGroupRequest,
        AwsError,
        zio.aws.finspacedata.model.DisassociateUserFromPermissionGroupResponse.ReadOnly
      ]
  object CreatePermissionGroup
      extends Effect[
        CreatePermissionGroupRequest,
        AwsError,
        zio.aws.finspacedata.model.CreatePermissionGroupResponse.ReadOnly
      ]
  object ListPermissionGroups
      extends Stream[
        ListPermissionGroupsRequest,
        AwsError,
        zio.aws.finspacedata.model.PermissionGroup.ReadOnly
      ]
  object ListPermissionGroupsPaginated
      extends Effect[
        ListPermissionGroupsRequest,
        AwsError,
        zio.aws.finspacedata.model.ListPermissionGroupsResponse.ReadOnly
      ]
  object UpdatePermissionGroup
      extends Effect[
        UpdatePermissionGroupRequest,
        AwsError,
        zio.aws.finspacedata.model.UpdatePermissionGroupResponse.ReadOnly
      ]
  object AssociateUserToPermissionGroup
      extends Effect[
        AssociateUserToPermissionGroupRequest,
        AwsError,
        zio.aws.finspacedata.model.AssociateUserToPermissionGroupResponse.ReadOnly
      ]
  object DeletePermissionGroup
      extends Effect[
        DeletePermissionGroupRequest,
        AwsError,
        zio.aws.finspacedata.model.DeletePermissionGroupResponse.ReadOnly
      ]
  object GetUser
      extends Effect[
        GetUserRequest,
        AwsError,
        zio.aws.finspacedata.model.GetUserResponse.ReadOnly
      ]
  object CreateUser
      extends Effect[
        CreateUserRequest,
        AwsError,
        zio.aws.finspacedata.model.CreateUserResponse.ReadOnly
      ]
  object UpdateDataset
      extends Effect[
        UpdateDatasetRequest,
        AwsError,
        zio.aws.finspacedata.model.UpdateDatasetResponse.ReadOnly
      ]
  object ListPermissionGroupsByUser
      extends Effect[
        ListPermissionGroupsByUserRequest,
        AwsError,
        zio.aws.finspacedata.model.ListPermissionGroupsByUserResponse.ReadOnly
      ]
  object DisableUser
      extends Effect[
        DisableUserRequest,
        AwsError,
        zio.aws.finspacedata.model.DisableUserResponse.ReadOnly
      ]
  object CreateChangeset
      extends Effect[
        CreateChangesetRequest,
        AwsError,
        zio.aws.finspacedata.model.CreateChangesetResponse.ReadOnly
      ]
  object GetChangeset
      extends Effect[
        GetChangesetRequest,
        AwsError,
        zio.aws.finspacedata.model.GetChangesetResponse.ReadOnly
      ]
  object UpdateChangeset
      extends Effect[
        UpdateChangesetRequest,
        AwsError,
        zio.aws.finspacedata.model.UpdateChangesetResponse.ReadOnly
      ]
  object ListDatasets
      extends Stream[
        ListDatasetsRequest,
        AwsError,
        zio.aws.finspacedata.model.Dataset.ReadOnly
      ]
  object ListDatasetsPaginated
      extends Effect[
        ListDatasetsRequest,
        AwsError,
        zio.aws.finspacedata.model.ListDatasetsResponse.ReadOnly
      ]
  object GetDataset
      extends Effect[
        GetDatasetRequest,
        AwsError,
        zio.aws.finspacedata.model.GetDatasetResponse.ReadOnly
      ]
  object GetDataView
      extends Effect[
        GetDataViewRequest,
        AwsError,
        zio.aws.finspacedata.model.GetDataViewResponse.ReadOnly
      ]
  object EnableUser
      extends Effect[
        EnableUserRequest,
        AwsError,
        zio.aws.finspacedata.model.EnableUserResponse.ReadOnly
      ]
  object ResetUserPassword
      extends Effect[
        ResetUserPasswordRequest,
        AwsError,
        zio.aws.finspacedata.model.ResetUserPasswordResponse.ReadOnly
      ]
  object GetPermissionGroup
      extends Effect[
        GetPermissionGroupRequest,
        AwsError,
        zio.aws.finspacedata.model.GetPermissionGroupResponse.ReadOnly
      ]
  object ListChangesets
      extends Stream[
        ListChangesetsRequest,
        AwsError,
        zio.aws.finspacedata.model.ChangesetSummary.ReadOnly
      ]
  object ListChangesetsPaginated
      extends Effect[
        ListChangesetsRequest,
        AwsError,
        zio.aws.finspacedata.model.ListChangesetsResponse.ReadOnly
      ]
  object GetProgrammaticAccessCredentials
      extends Effect[
        GetProgrammaticAccessCredentialsRequest,
        AwsError,
        ReadOnly
      ]
  object DeleteDataset
      extends Effect[
        DeleteDatasetRequest,
        AwsError,
        zio.aws.finspacedata.model.DeleteDatasetResponse.ReadOnly
      ]
  object GetWorkingLocation
      extends Effect[
        GetWorkingLocationRequest,
        AwsError,
        zio.aws.finspacedata.model.GetWorkingLocationResponse.ReadOnly
      ]
  object CreateDataView
      extends Effect[
        CreateDataViewRequest,
        AwsError,
        zio.aws.finspacedata.model.CreateDataViewResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, FinspaceData] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, FinspaceData] { rts =>
        zio.ZIO.succeed {
          new FinspaceData {
            val api: FinspaceDataAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): FinspaceData = this
            def createDataset(request: CreateDatasetRequest): IO[
              AwsError,
              zio.aws.finspacedata.model.CreateDatasetResponse.ReadOnly
            ] = proxy(CreateDataset, request)
            def getExternalDataViewAccessDetails(
                request: GetExternalDataViewAccessDetailsRequest
            ): IO[
              AwsError,
              zio.aws.finspacedata.model.GetExternalDataViewAccessDetailsResponse.ReadOnly
            ] = proxy(GetExternalDataViewAccessDetails, request)
            def listDataViews(request: ListDataViewsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.finspacedata.model.DataViewSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDataViews, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDataViewsPaginated(request: ListDataViewsRequest): IO[
              AwsError,
              zio.aws.finspacedata.model.ListDataViewsResponse.ReadOnly
            ] = proxy(ListDataViewsPaginated, request)
            def listUsers(request: ListUsersRequest): ZStream[
              Any,
              AwsError,
              zio.aws.finspacedata.model.User.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListUsers, request)
                }
                .getOrThrowFiberFailure()
            }
            def listUsersPaginated(request: ListUsersRequest): IO[
              AwsError,
              zio.aws.finspacedata.model.ListUsersResponse.ReadOnly
            ] = proxy(ListUsersPaginated, request)
            def updateUser(request: UpdateUserRequest): IO[
              AwsError,
              zio.aws.finspacedata.model.UpdateUserResponse.ReadOnly
            ] = proxy(UpdateUser, request)
            def listUsersByPermissionGroup(
                request: ListUsersByPermissionGroupRequest
            ): IO[
              AwsError,
              zio.aws.finspacedata.model.ListUsersByPermissionGroupResponse.ReadOnly
            ] = proxy(ListUsersByPermissionGroup, request)
            def disassociateUserFromPermissionGroup(
                request: DisassociateUserFromPermissionGroupRequest
            ): IO[
              AwsError,
              zio.aws.finspacedata.model.DisassociateUserFromPermissionGroupResponse.ReadOnly
            ] = proxy(DisassociateUserFromPermissionGroup, request)
            def createPermissionGroup(
                request: CreatePermissionGroupRequest
            ): IO[
              AwsError,
              zio.aws.finspacedata.model.CreatePermissionGroupResponse.ReadOnly
            ] = proxy(CreatePermissionGroup, request)
            def listPermissionGroups(
                request: ListPermissionGroupsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.finspacedata.model.PermissionGroup.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListPermissionGroups, request)
                }
                .getOrThrowFiberFailure()
            }
            def listPermissionGroupsPaginated(
                request: ListPermissionGroupsRequest
            ): IO[
              AwsError,
              zio.aws.finspacedata.model.ListPermissionGroupsResponse.ReadOnly
            ] = proxy(ListPermissionGroupsPaginated, request)
            def updatePermissionGroup(
                request: UpdatePermissionGroupRequest
            ): IO[
              AwsError,
              zio.aws.finspacedata.model.UpdatePermissionGroupResponse.ReadOnly
            ] = proxy(UpdatePermissionGroup, request)
            def associateUserToPermissionGroup(
                request: AssociateUserToPermissionGroupRequest
            ): IO[
              AwsError,
              zio.aws.finspacedata.model.AssociateUserToPermissionGroupResponse.ReadOnly
            ] = proxy(AssociateUserToPermissionGroup, request)
            def deletePermissionGroup(
                request: DeletePermissionGroupRequest
            ): IO[
              AwsError,
              zio.aws.finspacedata.model.DeletePermissionGroupResponse.ReadOnly
            ] = proxy(DeletePermissionGroup, request)
            def getUser(request: GetUserRequest): IO[
              AwsError,
              zio.aws.finspacedata.model.GetUserResponse.ReadOnly
            ] = proxy(GetUser, request)
            def createUser(request: CreateUserRequest): IO[
              AwsError,
              zio.aws.finspacedata.model.CreateUserResponse.ReadOnly
            ] = proxy(CreateUser, request)
            def updateDataset(request: UpdateDatasetRequest): IO[
              AwsError,
              zio.aws.finspacedata.model.UpdateDatasetResponse.ReadOnly
            ] = proxy(UpdateDataset, request)
            def listPermissionGroupsByUser(
                request: ListPermissionGroupsByUserRequest
            ): IO[
              AwsError,
              zio.aws.finspacedata.model.ListPermissionGroupsByUserResponse.ReadOnly
            ] = proxy(ListPermissionGroupsByUser, request)
            def disableUser(request: DisableUserRequest): IO[
              AwsError,
              zio.aws.finspacedata.model.DisableUserResponse.ReadOnly
            ] = proxy(DisableUser, request)
            def createChangeset(request: CreateChangesetRequest): IO[
              AwsError,
              zio.aws.finspacedata.model.CreateChangesetResponse.ReadOnly
            ] = proxy(CreateChangeset, request)
            def getChangeset(request: GetChangesetRequest): IO[
              AwsError,
              zio.aws.finspacedata.model.GetChangesetResponse.ReadOnly
            ] = proxy(GetChangeset, request)
            def updateChangeset(request: UpdateChangesetRequest): IO[
              AwsError,
              zio.aws.finspacedata.model.UpdateChangesetResponse.ReadOnly
            ] = proxy(UpdateChangeset, request)
            def listDatasets(request: ListDatasetsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.finspacedata.model.Dataset.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDatasets, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDatasetsPaginated(request: ListDatasetsRequest): IO[
              AwsError,
              zio.aws.finspacedata.model.ListDatasetsResponse.ReadOnly
            ] = proxy(ListDatasetsPaginated, request)
            def getDataset(request: GetDatasetRequest): IO[
              AwsError,
              zio.aws.finspacedata.model.GetDatasetResponse.ReadOnly
            ] = proxy(GetDataset, request)
            def getDataView(request: GetDataViewRequest): IO[
              AwsError,
              zio.aws.finspacedata.model.GetDataViewResponse.ReadOnly
            ] = proxy(GetDataView, request)
            def enableUser(request: EnableUserRequest): IO[
              AwsError,
              zio.aws.finspacedata.model.EnableUserResponse.ReadOnly
            ] = proxy(EnableUser, request)
            def resetUserPassword(request: ResetUserPasswordRequest): IO[
              AwsError,
              zio.aws.finspacedata.model.ResetUserPasswordResponse.ReadOnly
            ] = proxy(ResetUserPassword, request)
            def getPermissionGroup(request: GetPermissionGroupRequest): IO[
              AwsError,
              zio.aws.finspacedata.model.GetPermissionGroupResponse.ReadOnly
            ] = proxy(GetPermissionGroup, request)
            def listChangesets(request: ListChangesetsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.finspacedata.model.ChangesetSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListChangesets, request)
                }
                .getOrThrowFiberFailure()
            }
            def listChangesetsPaginated(request: ListChangesetsRequest): IO[
              AwsError,
              zio.aws.finspacedata.model.ListChangesetsResponse.ReadOnly
            ] = proxy(ListChangesetsPaginated, request)
            def getProgrammaticAccessCredentials(
                request: GetProgrammaticAccessCredentialsRequest
            ): IO[AwsError, ReadOnly] =
              proxy(GetProgrammaticAccessCredentials, request)
            def deleteDataset(request: DeleteDatasetRequest): IO[
              AwsError,
              zio.aws.finspacedata.model.DeleteDatasetResponse.ReadOnly
            ] = proxy(DeleteDataset, request)
            def getWorkingLocation(request: GetWorkingLocationRequest): IO[
              AwsError,
              zio.aws.finspacedata.model.GetWorkingLocationResponse.ReadOnly
            ] = proxy(GetWorkingLocation, request)
            def createDataView(request: CreateDataViewRequest): IO[
              AwsError,
              zio.aws.finspacedata.model.CreateDataViewResponse.ReadOnly
            ] = proxy(CreateDataView, request)
          }
        }
      }
    }
  }
}
