package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.{
  DatasetDescription,
  AliasString,
  DatasetTitle,
  ClientToken,
  DatasetId
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateDatasetRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    datasetId: DatasetId,
    datasetTitle: DatasetTitle,
    kind: zio.aws.finspacedata.model.DatasetKind,
    datasetDescription: Optional[DatasetDescription] = Optional.Absent,
    alias: Optional[AliasString] = Optional.Absent,
    schemaDefinition: Optional[zio.aws.finspacedata.model.SchemaUnion] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.UpdateDatasetRequest = {
    import UpdateDatasetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.UpdateDatasetRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .datasetId(DatasetId.unwrap(datasetId): java.lang.String)
      .datasetTitle(DatasetTitle.unwrap(datasetTitle): java.lang.String)
      .kind(kind.unwrap)
      .optionallyWith(
        datasetDescription.map(value =>
          DatasetDescription.unwrap(value): java.lang.String
        )
      )(_.datasetDescription)
      .optionallyWith(
        alias.map(value => AliasString.unwrap(value): java.lang.String)
      )(_.alias)
      .optionallyWith(schemaDefinition.map(value => value.buildAwsValue()))(
        _.schemaDefinition
      )
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.UpdateDatasetRequest.ReadOnly =
    zio.aws.finspacedata.model.UpdateDatasetRequest.wrap(buildAwsValue())
}
object UpdateDatasetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.UpdateDatasetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.UpdateDatasetRequest =
      zio.aws.finspacedata.model.UpdateDatasetRequest(
        clientToken.map(value => value),
        datasetId,
        datasetTitle,
        kind,
        datasetDescription.map(value => value),
        alias.map(value => value),
        schemaDefinition.map(value => value.asEditable)
      )
    def clientToken: Optional[ClientToken]
    def datasetId: DatasetId
    def datasetTitle: DatasetTitle
    def kind: zio.aws.finspacedata.model.DatasetKind
    def datasetDescription: Optional[DatasetDescription]
    def alias: Optional[AliasString]
    def schemaDefinition
        : Optional[zio.aws.finspacedata.model.SchemaUnion.ReadOnly]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDatasetId: ZIO[Any, Nothing, DatasetId] = ZIO.succeed(datasetId)
    def getDatasetTitle: ZIO[Any, Nothing, DatasetTitle] =
      ZIO.succeed(datasetTitle)
    def getKind: ZIO[Any, Nothing, zio.aws.finspacedata.model.DatasetKind] =
      ZIO.succeed(kind)
    def getDatasetDescription: ZIO[Any, AwsError, DatasetDescription] =
      AwsError.unwrapOptionField("datasetDescription", datasetDescription)
    def getAlias: ZIO[Any, AwsError, AliasString] =
      AwsError.unwrapOptionField("alias", alias)
    def getSchemaDefinition
        : ZIO[Any, AwsError, zio.aws.finspacedata.model.SchemaUnion.ReadOnly] =
      AwsError.unwrapOptionField("schemaDefinition", schemaDefinition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.UpdateDatasetRequest
  ) extends zio.aws.finspacedata.model.UpdateDatasetRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.finspacedata.model.primitives.ClientToken(value))
    override val datasetId: DatasetId =
      zio.aws.finspacedata.model.primitives.DatasetId(impl.datasetId())
    override val datasetTitle: DatasetTitle =
      zio.aws.finspacedata.model.primitives.DatasetTitle(impl.datasetTitle())
    override val kind: zio.aws.finspacedata.model.DatasetKind =
      zio.aws.finspacedata.model.DatasetKind.wrap(impl.kind())
    override val datasetDescription: Optional[DatasetDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.datasetDescription())
        .map(value =>
          zio.aws.finspacedata.model.primitives.DatasetDescription(value)
        )
    override val alias: Optional[AliasString] = zio.aws.core.internal
      .optionalFromNullable(impl.alias())
      .map(value => zio.aws.finspacedata.model.primitives.AliasString(value))
    override val schemaDefinition
        : Optional[zio.aws.finspacedata.model.SchemaUnion.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.schemaDefinition())
        .map(value => zio.aws.finspacedata.model.SchemaUnion.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.UpdateDatasetRequest
  ): zio.aws.finspacedata.model.UpdateDatasetRequest.ReadOnly = new Wrapper(
    impl
  )
}
