package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.finspacedata.model.primitives.{S3Key, S3BucketName}
import scala.jdk.CollectionConverters.*
final case class S3Location(bucket: S3BucketName, key: S3Key) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.S3Location = {
    import S3Location.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.S3Location
      .builder()
      .bucket(S3BucketName.unwrap(bucket): java.lang.String)
      .key(S3Key.unwrap(key): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.S3Location.ReadOnly =
    zio.aws.finspacedata.model.S3Location.wrap(buildAwsValue())
}
object S3Location {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.S3Location
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.S3Location =
      zio.aws.finspacedata.model.S3Location(bucket, key)
    def bucket: S3BucketName
    def key: S3Key
    def getBucket: ZIO[Any, Nothing, S3BucketName] = ZIO.succeed(bucket)
    def getKey: ZIO[Any, Nothing, S3Key] = ZIO.succeed(key)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.S3Location
  ) extends zio.aws.finspacedata.model.S3Location.ReadOnly {
    override val bucket: S3BucketName =
      zio.aws.finspacedata.model.primitives.S3BucketName(impl.bucket())
    override val key: S3Key =
      zio.aws.finspacedata.model.primitives.S3Key(impl.key())
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.S3Location
  ): zio.aws.finspacedata.model.S3Location.ReadOnly = new Wrapper(impl)
}
