package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.{
  StringValueLength1to255,
  TimestampEpoch,
  DataViewArn,
  DatasetId,
  DataViewId
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetDataViewResponse(
    autoUpdate: Optional[Boolean] = Optional.Absent,
    partitionColumns: Optional[Iterable[StringValueLength1to255]] =
      Optional.Absent,
    datasetId: Optional[DatasetId] = Optional.Absent,
    asOfTimestamp: Optional[TimestampEpoch] = Optional.Absent,
    errorInfo: Optional[zio.aws.finspacedata.model.DataViewErrorInfo] =
      Optional.Absent,
    lastModifiedTime: Optional[TimestampEpoch] = Optional.Absent,
    createTime: Optional[TimestampEpoch] = Optional.Absent,
    sortColumns: Optional[Iterable[StringValueLength1to255]] = Optional.Absent,
    dataViewId: Optional[DataViewId] = Optional.Absent,
    dataViewArn: Optional[DataViewArn] = Optional.Absent,
    destinationTypeParams: Optional[
      zio.aws.finspacedata.model.DataViewDestinationTypeParams
    ] = Optional.Absent,
    status: Optional[zio.aws.finspacedata.model.DataViewStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.GetDataViewResponse = {
    import GetDataViewResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.GetDataViewResponse
      .builder()
      .optionallyWith(autoUpdate.map(value => value: java.lang.Boolean))(
        _.autoUpdate
      )
      .optionallyWith(
        partitionColumns.map(value =>
          value.map { item =>
            StringValueLength1to255.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.partitionColumns)
      .optionallyWith(
        datasetId.map(value => DatasetId.unwrap(value): java.lang.String)
      )(_.datasetId)
      .optionallyWith(
        asOfTimestamp.map(value => TimestampEpoch.unwrap(value): java.lang.Long)
      )(_.asOfTimestamp)
      .optionallyWith(errorInfo.map(value => value.buildAwsValue()))(
        _.errorInfo
      )
      .optionallyWith(
        lastModifiedTime.map(value =>
          TimestampEpoch.unwrap(value): java.lang.Long
        )
      )(_.lastModifiedTime)
      .optionallyWith(
        createTime.map(value => TimestampEpoch.unwrap(value): java.lang.Long)
      )(_.createTime)
      .optionallyWith(
        sortColumns.map(value =>
          value.map { item =>
            StringValueLength1to255.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.sortColumns)
      .optionallyWith(
        dataViewId.map(value => DataViewId.unwrap(value): java.lang.String)
      )(_.dataViewId)
      .optionallyWith(
        dataViewArn.map(value => DataViewArn.unwrap(value): java.lang.String)
      )(_.dataViewArn)
      .optionallyWith(
        destinationTypeParams.map(value => value.buildAwsValue())
      )(_.destinationTypeParams)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.GetDataViewResponse.ReadOnly =
    zio.aws.finspacedata.model.GetDataViewResponse.wrap(buildAwsValue())
}
object GetDataViewResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.GetDataViewResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.GetDataViewResponse =
      zio.aws.finspacedata.model.GetDataViewResponse(
        autoUpdate.map(value => value),
        partitionColumns.map(value => value),
        datasetId.map(value => value),
        asOfTimestamp.map(value => value),
        errorInfo.map(value => value.asEditable),
        lastModifiedTime.map(value => value),
        createTime.map(value => value),
        sortColumns.map(value => value),
        dataViewId.map(value => value),
        dataViewArn.map(value => value),
        destinationTypeParams.map(value => value.asEditable),
        status.map(value => value)
      )
    def autoUpdate: Optional[Boolean]
    def partitionColumns: Optional[List[StringValueLength1to255]]
    def datasetId: Optional[DatasetId]
    def asOfTimestamp: Optional[TimestampEpoch]
    def errorInfo
        : Optional[zio.aws.finspacedata.model.DataViewErrorInfo.ReadOnly]
    def lastModifiedTime: Optional[TimestampEpoch]
    def createTime: Optional[TimestampEpoch]
    def sortColumns: Optional[List[StringValueLength1to255]]
    def dataViewId: Optional[DataViewId]
    def dataViewArn: Optional[DataViewArn]
    def destinationTypeParams: Optional[
      zio.aws.finspacedata.model.DataViewDestinationTypeParams.ReadOnly
    ]
    def status: Optional[zio.aws.finspacedata.model.DataViewStatus]
    def getAutoUpdate: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("autoUpdate", autoUpdate)
    def getPartitionColumns: ZIO[Any, AwsError, List[StringValueLength1to255]] =
      AwsError.unwrapOptionField("partitionColumns", partitionColumns)
    def getDatasetId: ZIO[Any, AwsError, DatasetId] =
      AwsError.unwrapOptionField("datasetId", datasetId)
    def getAsOfTimestamp: ZIO[Any, AwsError, TimestampEpoch] =
      AwsError.unwrapOptionField("asOfTimestamp", asOfTimestamp)
    def getErrorInfo: ZIO[
      Any,
      AwsError,
      zio.aws.finspacedata.model.DataViewErrorInfo.ReadOnly
    ] = AwsError.unwrapOptionField("errorInfo", errorInfo)
    def getLastModifiedTime: ZIO[Any, AwsError, TimestampEpoch] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getCreateTime: ZIO[Any, AwsError, TimestampEpoch] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getSortColumns: ZIO[Any, AwsError, List[StringValueLength1to255]] =
      AwsError.unwrapOptionField("sortColumns", sortColumns)
    def getDataViewId: ZIO[Any, AwsError, DataViewId] =
      AwsError.unwrapOptionField("dataViewId", dataViewId)
    def getDataViewArn: ZIO[Any, AwsError, DataViewArn] =
      AwsError.unwrapOptionField("dataViewArn", dataViewArn)
    def getDestinationTypeParams: ZIO[
      Any,
      AwsError,
      zio.aws.finspacedata.model.DataViewDestinationTypeParams.ReadOnly
    ] =
      AwsError.unwrapOptionField("destinationTypeParams", destinationTypeParams)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.finspacedata.model.DataViewStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.GetDataViewResponse
  ) extends zio.aws.finspacedata.model.GetDataViewResponse.ReadOnly {
    override val autoUpdate: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.autoUpdate())
      .map(value => value: Boolean)
    override val partitionColumns: Optional[List[StringValueLength1to255]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.partitionColumns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.finspacedata.model.primitives.StringValueLength1to255(item)
          }.toList
        )
    override val datasetId: Optional[DatasetId] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetId())
      .map(value => zio.aws.finspacedata.model.primitives.DatasetId(value))
    override val asOfTimestamp: Optional[TimestampEpoch] = zio.aws.core.internal
      .optionalFromNullable(impl.asOfTimestamp())
      .map(value => zio.aws.finspacedata.model.primitives.TimestampEpoch(value))
    override val errorInfo
        : Optional[zio.aws.finspacedata.model.DataViewErrorInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorInfo())
        .map(value => zio.aws.finspacedata.model.DataViewErrorInfo.wrap(value))
    override val lastModifiedTime: Optional[TimestampEpoch] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedTime())
        .map(value =>
          zio.aws.finspacedata.model.primitives.TimestampEpoch(value)
        )
    override val createTime: Optional[TimestampEpoch] = zio.aws.core.internal
      .optionalFromNullable(impl.createTime())
      .map(value => zio.aws.finspacedata.model.primitives.TimestampEpoch(value))
    override val sortColumns: Optional[List[StringValueLength1to255]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortColumns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.finspacedata.model.primitives.StringValueLength1to255(item)
          }.toList
        )
    override val dataViewId: Optional[DataViewId] = zio.aws.core.internal
      .optionalFromNullable(impl.dataViewId())
      .map(value => zio.aws.finspacedata.model.primitives.DataViewId(value))
    override val dataViewArn: Optional[DataViewArn] = zio.aws.core.internal
      .optionalFromNullable(impl.dataViewArn())
      .map(value => zio.aws.finspacedata.model.primitives.DataViewArn(value))
    override val destinationTypeParams: Optional[
      zio.aws.finspacedata.model.DataViewDestinationTypeParams.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.destinationTypeParams())
      .map(value =>
        zio.aws.finspacedata.model.DataViewDestinationTypeParams.wrap(value)
      )
    override val status: Optional[zio.aws.finspacedata.model.DataViewStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.finspacedata.model.DataViewStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.GetDataViewResponse
  ): zio.aws.finspacedata.model.GetDataViewResponse.ReadOnly = new Wrapper(impl)
}
