package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.finspacedata.model.primitives.{ChangesetId, DatasetId}
import scala.jdk.CollectionConverters.*
final case class GetChangesetRequest(
    datasetId: DatasetId,
    changesetId: ChangesetId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.GetChangesetRequest = {
    import GetChangesetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.GetChangesetRequest
      .builder()
      .datasetId(DatasetId.unwrap(datasetId): java.lang.String)
      .changesetId(ChangesetId.unwrap(changesetId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.GetChangesetRequest.ReadOnly =
    zio.aws.finspacedata.model.GetChangesetRequest.wrap(buildAwsValue())
}
object GetChangesetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.GetChangesetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.GetChangesetRequest =
      zio.aws.finspacedata.model.GetChangesetRequest(datasetId, changesetId)
    def datasetId: DatasetId
    def changesetId: ChangesetId
    def getDatasetId: ZIO[Any, Nothing, DatasetId] = ZIO.succeed(datasetId)
    def getChangesetId: ZIO[Any, Nothing, ChangesetId] =
      ZIO.succeed(changesetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.GetChangesetRequest
  ) extends zio.aws.finspacedata.model.GetChangesetRequest.ReadOnly {
    override val datasetId: DatasetId =
      zio.aws.finspacedata.model.primitives.DatasetId(impl.datasetId())
    override val changesetId: ChangesetId =
      zio.aws.finspacedata.model.primitives.ChangesetId(impl.changesetId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.GetChangesetRequest
  ): zio.aws.finspacedata.model.GetChangesetRequest.ReadOnly = new Wrapper(impl)
}
