package zio.aws.finspacedata.model
import scala.jdk.CollectionConverters.*
sealed trait ErrorCategory {
  def unwrap: software.amazon.awssdk.services.finspacedata.model.ErrorCategory
}
object ErrorCategory {
  def wrap(
      value: software.amazon.awssdk.services.finspacedata.model.ErrorCategory
  ): zio.aws.finspacedata.model.ErrorCategory = value match {
    case software.amazon.awssdk.services.finspacedata.model.ErrorCategory.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.finspacedata.model.ErrorCategory.VALIDATION =>
      val r = VALIDATION
      r
    case software.amazon.awssdk.services.finspacedata.model.ErrorCategory.SERVICE_QUOTA_EXCEEDED =>
      val r = SERVICE_QUOTA_EXCEEDED
      r
    case software.amazon.awssdk.services.finspacedata.model.ErrorCategory.ACCESS_DENIED =>
      val r = ACCESS_DENIED
      r
    case software.amazon.awssdk.services.finspacedata.model.ErrorCategory.RESOURCE_NOT_FOUND =>
      val r = RESOURCE_NOT_FOUND
      r
    case software.amazon.awssdk.services.finspacedata.model.ErrorCategory.THROTTLING =>
      val r = THROTTLING
      r
    case software.amazon.awssdk.services.finspacedata.model.ErrorCategory.INTERNAL_SERVICE_EXCEPTION =>
      val r = INTERNAL_SERVICE_EXCEPTION
      r
    case software.amazon.awssdk.services.finspacedata.model.ErrorCategory.CANCELLED =>
      val r = CANCELLED
      r
    case software.amazon.awssdk.services.finspacedata.model.ErrorCategory.USER_RECOVERABLE =>
      val r = USER_RECOVERABLE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.finspacedata.model.ErrorCategory {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.ErrorCategory =
      software.amazon.awssdk.services.finspacedata.model.ErrorCategory.UNKNOWN_TO_SDK_VERSION
  }
  case object VALIDATION extends zio.aws.finspacedata.model.ErrorCategory {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.ErrorCategory =
      software.amazon.awssdk.services.finspacedata.model.ErrorCategory.VALIDATION
  }
  case object SERVICE_QUOTA_EXCEEDED
      extends zio.aws.finspacedata.model.ErrorCategory {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.ErrorCategory =
      software.amazon.awssdk.services.finspacedata.model.ErrorCategory.SERVICE_QUOTA_EXCEEDED
  }
  case object ACCESS_DENIED extends zio.aws.finspacedata.model.ErrorCategory {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.ErrorCategory =
      software.amazon.awssdk.services.finspacedata.model.ErrorCategory.ACCESS_DENIED
  }
  case object RESOURCE_NOT_FOUND
      extends zio.aws.finspacedata.model.ErrorCategory {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.ErrorCategory =
      software.amazon.awssdk.services.finspacedata.model.ErrorCategory.RESOURCE_NOT_FOUND
  }
  case object THROTTLING extends zio.aws.finspacedata.model.ErrorCategory {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.ErrorCategory =
      software.amazon.awssdk.services.finspacedata.model.ErrorCategory.THROTTLING
  }
  case object INTERNAL_SERVICE_EXCEPTION
      extends zio.aws.finspacedata.model.ErrorCategory {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.ErrorCategory =
      software.amazon.awssdk.services.finspacedata.model.ErrorCategory.INTERNAL_SERVICE_EXCEPTION
  }
  case object CANCELLED extends zio.aws.finspacedata.model.ErrorCategory {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.ErrorCategory =
      software.amazon.awssdk.services.finspacedata.model.ErrorCategory.CANCELLED
  }
  case object USER_RECOVERABLE
      extends zio.aws.finspacedata.model.ErrorCategory {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.ErrorCategory =
      software.amazon.awssdk.services.finspacedata.model.ErrorCategory.USER_RECOVERABLE
  }
}
