package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.{
  StringValueLength1to255,
  TimestampEpoch,
  DataViewArn,
  DatasetId,
  DataViewId
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DataViewSummary(
    dataViewId: Optional[DataViewId] = Optional.Absent,
    dataViewArn: Optional[DataViewArn] = Optional.Absent,
    datasetId: Optional[DatasetId] = Optional.Absent,
    asOfTimestamp: Optional[TimestampEpoch] = Optional.Absent,
    partitionColumns: Optional[Iterable[StringValueLength1to255]] =
      Optional.Absent,
    sortColumns: Optional[Iterable[StringValueLength1to255]] = Optional.Absent,
    status: Optional[zio.aws.finspacedata.model.DataViewStatus] =
      Optional.Absent,
    errorInfo: Optional[zio.aws.finspacedata.model.DataViewErrorInfo] =
      Optional.Absent,
    destinationTypeProperties: Optional[
      zio.aws.finspacedata.model.DataViewDestinationTypeParams
    ] = Optional.Absent,
    autoUpdate: Optional[Boolean] = Optional.Absent,
    createTime: Optional[TimestampEpoch] = Optional.Absent,
    lastModifiedTime: Optional[TimestampEpoch] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.DataViewSummary = {
    import DataViewSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.DataViewSummary
      .builder()
      .optionallyWith(
        dataViewId.map(value => DataViewId.unwrap(value): java.lang.String)
      )(_.dataViewId)
      .optionallyWith(
        dataViewArn.map(value => DataViewArn.unwrap(value): java.lang.String)
      )(_.dataViewArn)
      .optionallyWith(
        datasetId.map(value => DatasetId.unwrap(value): java.lang.String)
      )(_.datasetId)
      .optionallyWith(
        asOfTimestamp.map(value => TimestampEpoch.unwrap(value): java.lang.Long)
      )(_.asOfTimestamp)
      .optionallyWith(
        partitionColumns.map(value =>
          value.map { item =>
            StringValueLength1to255.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.partitionColumns)
      .optionallyWith(
        sortColumns.map(value =>
          value.map { item =>
            StringValueLength1to255.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.sortColumns)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(errorInfo.map(value => value.buildAwsValue()))(
        _.errorInfo
      )
      .optionallyWith(
        destinationTypeProperties.map(value => value.buildAwsValue())
      )(_.destinationTypeProperties)
      .optionallyWith(autoUpdate.map(value => value: java.lang.Boolean))(
        _.autoUpdate
      )
      .optionallyWith(
        createTime.map(value => TimestampEpoch.unwrap(value): java.lang.Long)
      )(_.createTime)
      .optionallyWith(
        lastModifiedTime.map(value =>
          TimestampEpoch.unwrap(value): java.lang.Long
        )
      )(_.lastModifiedTime)
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.DataViewSummary.ReadOnly =
    zio.aws.finspacedata.model.DataViewSummary.wrap(buildAwsValue())
}
object DataViewSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.DataViewSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.DataViewSummary =
      zio.aws.finspacedata.model.DataViewSummary(
        dataViewId.map(value => value),
        dataViewArn.map(value => value),
        datasetId.map(value => value),
        asOfTimestamp.map(value => value),
        partitionColumns.map(value => value),
        sortColumns.map(value => value),
        status.map(value => value),
        errorInfo.map(value => value.asEditable),
        destinationTypeProperties.map(value => value.asEditable),
        autoUpdate.map(value => value),
        createTime.map(value => value),
        lastModifiedTime.map(value => value)
      )
    def dataViewId: Optional[DataViewId]
    def dataViewArn: Optional[DataViewArn]
    def datasetId: Optional[DatasetId]
    def asOfTimestamp: Optional[TimestampEpoch]
    def partitionColumns: Optional[List[StringValueLength1to255]]
    def sortColumns: Optional[List[StringValueLength1to255]]
    def status: Optional[zio.aws.finspacedata.model.DataViewStatus]
    def errorInfo
        : Optional[zio.aws.finspacedata.model.DataViewErrorInfo.ReadOnly]
    def destinationTypeProperties: Optional[
      zio.aws.finspacedata.model.DataViewDestinationTypeParams.ReadOnly
    ]
    def autoUpdate: Optional[Boolean]
    def createTime: Optional[TimestampEpoch]
    def lastModifiedTime: Optional[TimestampEpoch]
    def getDataViewId: ZIO[Any, AwsError, DataViewId] =
      AwsError.unwrapOptionField("dataViewId", dataViewId)
    def getDataViewArn: ZIO[Any, AwsError, DataViewArn] =
      AwsError.unwrapOptionField("dataViewArn", dataViewArn)
    def getDatasetId: ZIO[Any, AwsError, DatasetId] =
      AwsError.unwrapOptionField("datasetId", datasetId)
    def getAsOfTimestamp: ZIO[Any, AwsError, TimestampEpoch] =
      AwsError.unwrapOptionField("asOfTimestamp", asOfTimestamp)
    def getPartitionColumns: ZIO[Any, AwsError, List[StringValueLength1to255]] =
      AwsError.unwrapOptionField("partitionColumns", partitionColumns)
    def getSortColumns: ZIO[Any, AwsError, List[StringValueLength1to255]] =
      AwsError.unwrapOptionField("sortColumns", sortColumns)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.finspacedata.model.DataViewStatus] =
      AwsError.unwrapOptionField("status", status)
    def getErrorInfo: ZIO[
      Any,
      AwsError,
      zio.aws.finspacedata.model.DataViewErrorInfo.ReadOnly
    ] = AwsError.unwrapOptionField("errorInfo", errorInfo)
    def getDestinationTypeProperties: ZIO[
      Any,
      AwsError,
      zio.aws.finspacedata.model.DataViewDestinationTypeParams.ReadOnly
    ] = AwsError.unwrapOptionField(
      "destinationTypeProperties",
      destinationTypeProperties
    )
    def getAutoUpdate: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("autoUpdate", autoUpdate)
    def getCreateTime: ZIO[Any, AwsError, TimestampEpoch] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getLastModifiedTime: ZIO[Any, AwsError, TimestampEpoch] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.DataViewSummary
  ) extends zio.aws.finspacedata.model.DataViewSummary.ReadOnly {
    override val dataViewId: Optional[DataViewId] = zio.aws.core.internal
      .optionalFromNullable(impl.dataViewId())
      .map(value => zio.aws.finspacedata.model.primitives.DataViewId(value))
    override val dataViewArn: Optional[DataViewArn] = zio.aws.core.internal
      .optionalFromNullable(impl.dataViewArn())
      .map(value => zio.aws.finspacedata.model.primitives.DataViewArn(value))
    override val datasetId: Optional[DatasetId] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetId())
      .map(value => zio.aws.finspacedata.model.primitives.DatasetId(value))
    override val asOfTimestamp: Optional[TimestampEpoch] = zio.aws.core.internal
      .optionalFromNullable(impl.asOfTimestamp())
      .map(value => zio.aws.finspacedata.model.primitives.TimestampEpoch(value))
    override val partitionColumns: Optional[List[StringValueLength1to255]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.partitionColumns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.finspacedata.model.primitives.StringValueLength1to255(item)
          }.toList
        )
    override val sortColumns: Optional[List[StringValueLength1to255]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortColumns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.finspacedata.model.primitives.StringValueLength1to255(item)
          }.toList
        )
    override val status: Optional[zio.aws.finspacedata.model.DataViewStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.finspacedata.model.DataViewStatus.wrap(value))
    override val errorInfo
        : Optional[zio.aws.finspacedata.model.DataViewErrorInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorInfo())
        .map(value => zio.aws.finspacedata.model.DataViewErrorInfo.wrap(value))
    override val destinationTypeProperties: Optional[
      zio.aws.finspacedata.model.DataViewDestinationTypeParams.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.destinationTypeProperties())
      .map(value =>
        zio.aws.finspacedata.model.DataViewDestinationTypeParams.wrap(value)
      )
    override val autoUpdate: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.autoUpdate())
      .map(value => value: Boolean)
    override val createTime: Optional[TimestampEpoch] = zio.aws.core.internal
      .optionalFromNullable(impl.createTime())
      .map(value => zio.aws.finspacedata.model.primitives.TimestampEpoch(value))
    override val lastModifiedTime: Optional[TimestampEpoch] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedTime())
        .map(value =>
          zio.aws.finspacedata.model.primitives.TimestampEpoch(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.DataViewSummary
  ): zio.aws.finspacedata.model.DataViewSummary.ReadOnly = new Wrapper(impl)
}
