package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.{
  StringValueMaxLength1000,
  StringValueLength1to255
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Credentials(
    accessKeyId: Optional[StringValueLength1to255] = Optional.Absent,
    secretAccessKey: Optional[StringValueMaxLength1000] = Optional.Absent,
    sessionToken: Optional[StringValueMaxLength1000] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.Credentials = {
    import Credentials.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.Credentials
      .builder()
      .optionallyWith(
        accessKeyId.map(value =>
          StringValueLength1to255.unwrap(value): java.lang.String
        )
      )(_.accessKeyId)
      .optionallyWith(
        secretAccessKey.map(value =>
          StringValueMaxLength1000.unwrap(value): java.lang.String
        )
      )(_.secretAccessKey)
      .optionallyWith(
        sessionToken.map(value =>
          StringValueMaxLength1000.unwrap(value): java.lang.String
        )
      )(_.sessionToken)
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.Credentials.ReadOnly =
    zio.aws.finspacedata.model.Credentials.wrap(buildAwsValue())
}
object Credentials {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.Credentials
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.Credentials =
      zio.aws.finspacedata.model.Credentials(
        accessKeyId.map(value => value),
        secretAccessKey.map(value => value),
        sessionToken.map(value => value)
      )
    def accessKeyId: Optional[StringValueLength1to255]
    def secretAccessKey: Optional[StringValueMaxLength1000]
    def sessionToken: Optional[StringValueMaxLength1000]
    def getAccessKeyId: ZIO[Any, AwsError, StringValueLength1to255] =
      AwsError.unwrapOptionField("accessKeyId", accessKeyId)
    def getSecretAccessKey: ZIO[Any, AwsError, StringValueMaxLength1000] =
      AwsError.unwrapOptionField("secretAccessKey", secretAccessKey)
    def getSessionToken: ZIO[Any, AwsError, StringValueMaxLength1000] =
      AwsError.unwrapOptionField("sessionToken", sessionToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.Credentials
  ) extends zio.aws.finspacedata.model.Credentials.ReadOnly {
    override val accessKeyId: Optional[StringValueLength1to255] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessKeyId())
        .map(value =>
          zio.aws.finspacedata.model.primitives.StringValueLength1to255(value)
        )
    override val secretAccessKey: Optional[StringValueMaxLength1000] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secretAccessKey())
        .map(value =>
          zio.aws.finspacedata.model.primitives.StringValueMaxLength1000(value)
        )
    override val sessionToken: Optional[StringValueMaxLength1000] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sessionToken())
        .map(value =>
          zio.aws.finspacedata.model.primitives.StringValueMaxLength1000(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.Credentials
  ): zio.aws.finspacedata.model.Credentials.ReadOnly = new Wrapper(impl)
}
