package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.{
  TimestampEpoch,
  SessionToken,
  SecretAccessKey,
  AccessKeyId
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AwsCredentials(
    accessKeyId: Optional[AccessKeyId] = Optional.Absent,
    secretAccessKey: Optional[SecretAccessKey] = Optional.Absent,
    sessionToken: Optional[SessionToken] = Optional.Absent,
    expiration: Optional[TimestampEpoch] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.AwsCredentials = {
    import AwsCredentials.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.AwsCredentials
      .builder()
      .optionallyWith(
        accessKeyId.map(value => AccessKeyId.unwrap(value): java.lang.String)
      )(_.accessKeyId)
      .optionallyWith(
        secretAccessKey.map(value =>
          SecretAccessKey.unwrap(value): java.lang.String
        )
      )(_.secretAccessKey)
      .optionallyWith(
        sessionToken.map(value => SessionToken.unwrap(value): java.lang.String)
      )(_.sessionToken)
      .optionallyWith(
        expiration.map(value => TimestampEpoch.unwrap(value): java.lang.Long)
      )(_.expiration)
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.AwsCredentials.ReadOnly =
    zio.aws.finspacedata.model.AwsCredentials.wrap(buildAwsValue())
}
object AwsCredentials {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.AwsCredentials
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.AwsCredentials =
      zio.aws.finspacedata.model.AwsCredentials(
        accessKeyId.map(value => value),
        secretAccessKey.map(value => value),
        sessionToken.map(value => value),
        expiration.map(value => value)
      )
    def accessKeyId: Optional[AccessKeyId]
    def secretAccessKey: Optional[SecretAccessKey]
    def sessionToken: Optional[SessionToken]
    def expiration: Optional[TimestampEpoch]
    def getAccessKeyId: ZIO[Any, AwsError, AccessKeyId] =
      AwsError.unwrapOptionField("accessKeyId", accessKeyId)
    def getSecretAccessKey: ZIO[Any, AwsError, SecretAccessKey] =
      AwsError.unwrapOptionField("secretAccessKey", secretAccessKey)
    def getSessionToken: ZIO[Any, AwsError, SessionToken] =
      AwsError.unwrapOptionField("sessionToken", sessionToken)
    def getExpiration: ZIO[Any, AwsError, TimestampEpoch] =
      AwsError.unwrapOptionField("expiration", expiration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.AwsCredentials
  ) extends zio.aws.finspacedata.model.AwsCredentials.ReadOnly {
    override val accessKeyId: Optional[AccessKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.accessKeyId())
      .map(value => zio.aws.finspacedata.model.primitives.AccessKeyId(value))
    override val secretAccessKey: Optional[SecretAccessKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secretAccessKey())
        .map(value =>
          zio.aws.finspacedata.model.primitives.SecretAccessKey(value)
        )
    override val sessionToken: Optional[SessionToken] = zio.aws.core.internal
      .optionalFromNullable(impl.sessionToken())
      .map(value => zio.aws.finspacedata.model.primitives.SessionToken(value))
    override val expiration: Optional[TimestampEpoch] = zio.aws.core.internal
      .optionalFromNullable(impl.expiration())
      .map(value => zio.aws.finspacedata.model.primitives.TimestampEpoch(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.AwsCredentials
  ): zio.aws.finspacedata.model.AwsCredentials.ReadOnly = new Wrapper(impl)
}
