package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.{
  RoleArn,
  UserId,
  Email,
  FirstName,
  LastName
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UserByPermissionGroup(
    userId: Optional[UserId] = Optional.Absent,
    status: Optional[zio.aws.finspacedata.model.UserStatus] = Optional.Absent,
    firstName: Optional[FirstName] = Optional.Absent,
    lastName: Optional[LastName] = Optional.Absent,
    emailAddress: Optional[Email] = Optional.Absent,
    `type`: Optional[zio.aws.finspacedata.model.UserType] = Optional.Absent,
    apiAccess: Optional[zio.aws.finspacedata.model.ApiAccess] = Optional.Absent,
    apiAccessPrincipalArn: Optional[RoleArn] = Optional.Absent,
    membershipStatus: Optional[
      zio.aws.finspacedata.model.PermissionGroupMembershipStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.UserByPermissionGroup = {
    import UserByPermissionGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.UserByPermissionGroup
      .builder()
      .optionallyWith(
        userId.map(value => UserId.unwrap(value): java.lang.String)
      )(_.userId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        firstName.map(value => FirstName.unwrap(value): java.lang.String)
      )(_.firstName)
      .optionallyWith(
        lastName.map(value => LastName.unwrap(value): java.lang.String)
      )(_.lastName)
      .optionallyWith(
        emailAddress.map(value => Email.unwrap(value): java.lang.String)
      )(_.emailAddress)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(apiAccess.map(value => value.unwrap))(_.apiAccess)
      .optionallyWith(
        apiAccessPrincipalArn.map(value =>
          RoleArn.unwrap(value): java.lang.String
        )
      )(_.apiAccessPrincipalArn)
      .optionallyWith(membershipStatus.map(value => value.unwrap))(
        _.membershipStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.UserByPermissionGroup.ReadOnly =
    zio.aws.finspacedata.model.UserByPermissionGroup.wrap(buildAwsValue())
}
object UserByPermissionGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.UserByPermissionGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.UserByPermissionGroup =
      zio.aws.finspacedata.model.UserByPermissionGroup(
        userId.map(value => value),
        status.map(value => value),
        firstName.map(value => value),
        lastName.map(value => value),
        emailAddress.map(value => value),
        `type`.map(value => value),
        apiAccess.map(value => value),
        apiAccessPrincipalArn.map(value => value),
        membershipStatus.map(value => value)
      )
    def userId: Optional[UserId]
    def status: Optional[zio.aws.finspacedata.model.UserStatus]
    def firstName: Optional[FirstName]
    def lastName: Optional[LastName]
    def emailAddress: Optional[Email]
    def `type`: Optional[zio.aws.finspacedata.model.UserType]
    def apiAccess: Optional[zio.aws.finspacedata.model.ApiAccess]
    def apiAccessPrincipalArn: Optional[RoleArn]
    def membershipStatus
        : Optional[zio.aws.finspacedata.model.PermissionGroupMembershipStatus]
    def getUserId: ZIO[Any, AwsError, UserId] =
      AwsError.unwrapOptionField("userId", userId)
    def getStatus: ZIO[Any, AwsError, zio.aws.finspacedata.model.UserStatus] =
      AwsError.unwrapOptionField("status", status)
    def getFirstName: ZIO[Any, AwsError, FirstName] =
      AwsError.unwrapOptionField("firstName", firstName)
    def getLastName: ZIO[Any, AwsError, LastName] =
      AwsError.unwrapOptionField("lastName", lastName)
    def getEmailAddress: ZIO[Any, AwsError, Email] =
      AwsError.unwrapOptionField("emailAddress", emailAddress)
    def getType: ZIO[Any, AwsError, zio.aws.finspacedata.model.UserType] =
      AwsError.unwrapOptionField("type", `type`)
    def getApiAccess: ZIO[Any, AwsError, zio.aws.finspacedata.model.ApiAccess] =
      AwsError.unwrapOptionField("apiAccess", apiAccess)
    def getApiAccessPrincipalArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("apiAccessPrincipalArn", apiAccessPrincipalArn)
    def getMembershipStatus: ZIO[
      Any,
      AwsError,
      zio.aws.finspacedata.model.PermissionGroupMembershipStatus
    ] = AwsError.unwrapOptionField("membershipStatus", membershipStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.UserByPermissionGroup
  ) extends zio.aws.finspacedata.model.UserByPermissionGroup.ReadOnly {
    override val userId: Optional[UserId] = zio.aws.core.internal
      .optionalFromNullable(impl.userId())
      .map(value => zio.aws.finspacedata.model.primitives.UserId(value))
    override val status: Optional[zio.aws.finspacedata.model.UserStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.finspacedata.model.UserStatus.wrap(value))
    override val firstName: Optional[FirstName] = zio.aws.core.internal
      .optionalFromNullable(impl.firstName())
      .map(value => zio.aws.finspacedata.model.primitives.FirstName(value))
    override val lastName: Optional[LastName] = zio.aws.core.internal
      .optionalFromNullable(impl.lastName())
      .map(value => zio.aws.finspacedata.model.primitives.LastName(value))
    override val emailAddress: Optional[Email] = zio.aws.core.internal
      .optionalFromNullable(impl.emailAddress())
      .map(value => zio.aws.finspacedata.model.primitives.Email(value))
    override val `type`: Optional[zio.aws.finspacedata.model.UserType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.finspacedata.model.UserType.wrap(value))
    override val apiAccess: Optional[zio.aws.finspacedata.model.ApiAccess] =
      zio.aws.core.internal
        .optionalFromNullable(impl.apiAccess())
        .map(value => zio.aws.finspacedata.model.ApiAccess.wrap(value))
    override val apiAccessPrincipalArn: Optional[RoleArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.apiAccessPrincipalArn())
        .map(value => zio.aws.finspacedata.model.primitives.RoleArn(value))
    override val membershipStatus
        : Optional[zio.aws.finspacedata.model.PermissionGroupMembershipStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.membershipStatus())
        .map(value =>
          zio.aws.finspacedata.model.PermissionGroupMembershipStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.UserByPermissionGroup
  ): zio.aws.finspacedata.model.UserByPermissionGroup.ReadOnly = new Wrapper(
    impl
  )
}
