package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.{
  ClientToken,
  PermissionGroupDescription,
  PermissionGroupName,
  PermissionGroupId
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdatePermissionGroupRequest(
    permissionGroupId: PermissionGroupId,
    name: Optional[PermissionGroupName] = Optional.Absent,
    description: Optional[PermissionGroupDescription] = Optional.Absent,
    applicationPermissions: Optional[
      Iterable[zio.aws.finspacedata.model.ApplicationPermission]
    ] = Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.UpdatePermissionGroupRequest = {
    import UpdatePermissionGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.UpdatePermissionGroupRequest
      .builder()
      .permissionGroupId(
        PermissionGroupId.unwrap(permissionGroupId): java.lang.String
      )
      .optionallyWith(
        name.map(value => PermissionGroupName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          PermissionGroupDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        applicationPermissions.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.applicationPermissionsWithStrings)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly
      : zio.aws.finspacedata.model.UpdatePermissionGroupRequest.ReadOnly =
    zio.aws.finspacedata.model.UpdatePermissionGroupRequest
      .wrap(buildAwsValue())
}
object UpdatePermissionGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.UpdatePermissionGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.UpdatePermissionGroupRequest =
      zio.aws.finspacedata.model.UpdatePermissionGroupRequest(
        permissionGroupId,
        name.map(value => value),
        description.map(value => value),
        applicationPermissions.map(value => value),
        clientToken.map(value => value)
      )
    def permissionGroupId: PermissionGroupId
    def name: Optional[PermissionGroupName]
    def description: Optional[PermissionGroupDescription]
    def applicationPermissions
        : Optional[List[zio.aws.finspacedata.model.ApplicationPermission]]
    def clientToken: Optional[ClientToken]
    def getPermissionGroupId: ZIO[Any, Nothing, PermissionGroupId] =
      ZIO.succeed(permissionGroupId)
    def getName: ZIO[Any, AwsError, PermissionGroupName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, PermissionGroupDescription] =
      AwsError.unwrapOptionField("description", description)
    def getApplicationPermissions: ZIO[Any, AwsError, List[
      zio.aws.finspacedata.model.ApplicationPermission
    ]] = AwsError.unwrapOptionField(
      "applicationPermissions",
      applicationPermissions
    )
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.UpdatePermissionGroupRequest
  ) extends zio.aws.finspacedata.model.UpdatePermissionGroupRequest.ReadOnly {
    override val permissionGroupId: PermissionGroupId =
      zio.aws.finspacedata.model.primitives
        .PermissionGroupId(impl.permissionGroupId())
    override val name: Optional[PermissionGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.finspacedata.model.primitives.PermissionGroupName(value)
      )
    override val description: Optional[PermissionGroupDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.finspacedata.model.primitives
            .PermissionGroupDescription(value)
        )
    override val applicationPermissions
        : Optional[List[zio.aws.finspacedata.model.ApplicationPermission]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationPermissions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.finspacedata.model.ApplicationPermission.wrap(item)
          }.toList
        )
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.finspacedata.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.UpdatePermissionGroupRequest
  ): zio.aws.finspacedata.model.UpdatePermissionGroupRequest.ReadOnly =
    new Wrapper(impl)
}
