package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.{
  StringMapValue,
  ClientToken,
  ChangesetId,
  StringMapKey,
  DatasetId
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateChangesetRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    datasetId: DatasetId,
    changesetId: ChangesetId,
    sourceParams: Map[StringMapKey, StringMapValue],
    formatParams: Map[StringMapKey, StringMapValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.UpdateChangesetRequest = {
    import UpdateChangesetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.UpdateChangesetRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .datasetId(DatasetId.unwrap(datasetId): java.lang.String)
      .changesetId(ChangesetId.unwrap(changesetId): java.lang.String)
      .sourceParams(
        sourceParams
          .map({ case (key, value) =>
            (StringMapKey.unwrap(key): java.lang.String) -> (StringMapValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .formatParams(
        formatParams
          .map({ case (key, value) =>
            (StringMapKey.unwrap(key): java.lang.String) -> (StringMapValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.UpdateChangesetRequest.ReadOnly =
    zio.aws.finspacedata.model.UpdateChangesetRequest.wrap(buildAwsValue())
}
object UpdateChangesetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.UpdateChangesetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.UpdateChangesetRequest =
      zio.aws.finspacedata.model.UpdateChangesetRequest(
        clientToken.map(value => value),
        datasetId,
        changesetId,
        sourceParams,
        formatParams
      )
    def clientToken: Optional[ClientToken]
    def datasetId: DatasetId
    def changesetId: ChangesetId
    def sourceParams: Map[StringMapKey, StringMapValue]
    def formatParams: Map[StringMapKey, StringMapValue]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDatasetId: ZIO[Any, Nothing, DatasetId] = ZIO.succeed(datasetId)
    def getChangesetId: ZIO[Any, Nothing, ChangesetId] =
      ZIO.succeed(changesetId)
    def getSourceParams: ZIO[Any, Nothing, Map[StringMapKey, StringMapValue]] =
      ZIO.succeed(sourceParams)
    def getFormatParams: ZIO[Any, Nothing, Map[StringMapKey, StringMapValue]] =
      ZIO.succeed(formatParams)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.UpdateChangesetRequest
  ) extends zio.aws.finspacedata.model.UpdateChangesetRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.finspacedata.model.primitives.ClientToken(value))
    override val datasetId: DatasetId =
      zio.aws.finspacedata.model.primitives.DatasetId(impl.datasetId())
    override val changesetId: ChangesetId =
      zio.aws.finspacedata.model.primitives.ChangesetId(impl.changesetId())
    override val sourceParams: Map[StringMapKey, StringMapValue] = impl
      .sourceParams()
      .asScala
      .map({ case (key, value) =>
        zio.aws.finspacedata.model.primitives.StringMapKey(
          key
        ) -> zio.aws.finspacedata.model.primitives.StringMapValue(value)
      })
      .toMap
    override val formatParams: Map[StringMapKey, StringMapValue] = impl
      .formatParams()
      .asScala
      .map({ case (key, value) =>
        zio.aws.finspacedata.model.primitives.StringMapKey(
          key
        ) -> zio.aws.finspacedata.model.primitives.StringMapValue(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.UpdateChangesetRequest
  ): zio.aws.finspacedata.model.UpdateChangesetRequest.ReadOnly = new Wrapper(
    impl
  )
}
