package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SchemaUnion(
    tabularSchemaConfig: Optional[zio.aws.finspacedata.model.SchemaDefinition] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.SchemaUnion = {
    import SchemaUnion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.SchemaUnion
      .builder()
      .optionallyWith(tabularSchemaConfig.map(value => value.buildAwsValue()))(
        _.tabularSchemaConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.SchemaUnion.ReadOnly =
    zio.aws.finspacedata.model.SchemaUnion.wrap(buildAwsValue())
}
object SchemaUnion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.SchemaUnion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.SchemaUnion =
      zio.aws.finspacedata.model
        .SchemaUnion(tabularSchemaConfig.map(value => value.asEditable))
    def tabularSchemaConfig
        : Optional[zio.aws.finspacedata.model.SchemaDefinition.ReadOnly]
    def getTabularSchemaConfig: ZIO[
      Any,
      AwsError,
      zio.aws.finspacedata.model.SchemaDefinition.ReadOnly
    ] = AwsError.unwrapOptionField("tabularSchemaConfig", tabularSchemaConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.SchemaUnion
  ) extends zio.aws.finspacedata.model.SchemaUnion.ReadOnly {
    override val tabularSchemaConfig
        : Optional[zio.aws.finspacedata.model.SchemaDefinition.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tabularSchemaConfig())
        .map(value => zio.aws.finspacedata.model.SchemaDefinition.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.SchemaUnion
  ): zio.aws.finspacedata.model.SchemaUnion.ReadOnly = new Wrapper(impl)
}
